/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.internal.NullTrace;
import org.openqa.selenium.internal.Trace;
import org.openqa.selenium.io.FileHandler;

public class ResourceExtractor {
    private static Trace log = new NullTrace();

    public static File extractResourcePath(Class cl, String resourcePath, File dest) throws IOException {
        boolean alwaysExtract = true;
        URL url = Resources.getResource((Class)cl, (String)resourcePath);
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            File jarFile = ResourceExtractor.getJarFileFromUrl(url);
            ResourceExtractor.extractResourcePathFromJar(cl, jarFile, resourcePath, dest);
        } else {
            try {
                File resourceFile = new File(new URI(url.toExternalForm()));
                if (!alwaysExtract) {
                    return resourceFile;
                }
                if (resourceFile.isDirectory()) {
                    LauncherUtils.copyDirectory((File)resourceFile, (File)dest);
                } else {
                    FileHandler.copy((File)resourceFile, (File)dest);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Couldn't convert URL to File:" + url, e);
            }
        }
        return dest;
    }

    private static void extractResourcePathFromJar(Class cl, File jarFile, String resourcePath, File dest) throws IOException {
        ZipFile z = new ZipFile(jarFile, 1);
        String zipStyleResourcePath = resourcePath.substring(1) + "/";
        ZipEntry ze = z.getEntry(zipStyleResourcePath);
        log.debug("Extracting " + resourcePath + " to " + dest.getAbsolutePath());
        if (ze != null) {
            Enumeration<? extends ZipEntry> entries = z.entries();
            while (entries.hasMoreElements()) {
                ze = entries.nextElement();
                if (!ze.getName().startsWith(zipStyleResourcePath)) continue;
                String relativePath = ze.getName().substring(zipStyleResourcePath.length());
                File destFile = new File(dest, relativePath);
                if (ze.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(destFile);
                ResourceExtractor.copyStream(z.getInputStream(ze), fos);
            }
        } else {
            FileOutputStream fos = new FileOutputStream(dest);
            ResourceExtractor.copyStream(LauncherUtils.getSeleniumResourceAsStream((String)resourcePath), fos);
        }
    }

    public static void traceWith(Trace log) {
        ResourceExtractor.log = log;
    }

    private static File getJarFileFromUrl(URL url) {
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("This is not a Jar URL:" + url.toString());
        }
        String resourceFilePath = url.getFile();
        int index = resourceFilePath.lastIndexOf("!");
        if (index == -1) {
            throw new RuntimeException("Bug! " + url.toExternalForm() + " does not have a '!'");
        }
        String jarFileURI = resourceFilePath.substring(0, index).replace(" ", "%20");
        try {
            File jarFile = new File(new URI(jarFileURI));
            return jarFile;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug! URI failed to parse: " + jarFileURI, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Closeables.close((Closeable)out, (boolean)true);
            Closeables.close((Closeable)in, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)out, (boolean)true);
        Closeables.close((Closeable)in, (boolean)true);
    }
}

