/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.html5;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;
import org.openqa.selenium.remote.server.handler.internal.ResultConverter;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteSQL
extends WebDriverHandler
implements JsonParametersAware {
    private Response response;
    private String dbName;
    private String query;
    private List<Object> args = Lists.newArrayList();

    public ExecuteSQL(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        ResultSet value = ((DatabaseStorage)this.unwrap(this.getDriver())).executeSQL(this.dbName, this.query, this.args.toArray());
        Object result = new ResultConverter(this.getKnownElements()).apply(value);
        this.response.setValue(result);
        return ResultType.SUCCESS;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.dbName = (String)allParameters.get("dbName");
        this.query = (String)allParameters.get("query");
        List params = (List)allParameters.get("args");
        this.args = Lists.newArrayList((Iterable)Iterables.transform((Iterable)params, (Function)new ArgumentConverter(this.getKnownElements())));
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[execute SQL query: %s, %s, %s]", this.dbName, this.query, this.args);
    }
}

