/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import org.openqa.selenium.internal.Trace;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.DeleteSession;

class SessionCleaner
extends Thread {
    private final DriverSessions driverSessions;
    private final int timeoutMs;
    private final Trace trace;
    private volatile boolean running = true;

    SessionCleaner(DriverSessions driverSessions, Trace trace, int sessionTimeOutInMs) {
        super("DriverServlet Session Cleaner");
        this.trace = trace;
        this.timeoutMs = sessionTimeOutInMs;
        this.driverSessions = driverSessions;
    }

    public void run() {
        while (this.running) {
            this.checkExpiry();
            try {
                Thread.sleep(this.timeoutMs / 10);
            }
            catch (InterruptedException e) {
                this.trace.info("Exiting session cleaner thread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopCleaner() {
        this.running = false;
        SessionCleaner sessionCleaner = this;
        synchronized (sessionCleaner) {
            this.interrupt();
        }
    }

    void checkExpiry() {
        for (SessionId sessionId : this.driverSessions.getSessions()) {
            Session session = this.driverSessions.get(sessionId);
            if (session == null || !session.isTimedOut(this.timeoutMs)) continue;
            DeleteSession deleteSession = new DeleteSession(this.driverSessions);
            deleteSession.setSessionId(sessionId.toString());
            try {
                deleteSession.call();
                this.trace.info("Session " + session + " deleted due to timeout");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

