/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.ProxyPac;

public class BrowserConfigurationOptions {
    private Map<String, String> options = new HashMap<String, String>();
    private boolean hasOptions = false;

    public BrowserConfigurationOptions(String browserConfiguration) {
        String[] optionsPairList = browserConfiguration.split(";");
        for (int i = 0; i < optionsPairList.length; ++i) {
            String[] option = optionsPairList[i].split("=", 2);
            if (2 != option.length) continue;
            String optionsName = option[0].trim();
            String optionValue = option[1].trim();
            this.options.put(optionsName, optionValue);
            this.hasOptions = true;
        }
    }

    public BrowserConfigurationOptions() {
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : this.options.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append(key).append(':').append(this.options.get(key));
        }
        return sb.toString();
    }

    public String getProfile() {
        return this.options.get("profile");
    }

    public boolean hasOptions() {
        return this.hasOptions;
    }

    public boolean isSingleWindow() {
        return this.is("singleWindow");
    }

    public void setSingleWindow(Boolean singleWindow) {
        this.options.put("singleWindow", singleWindow.toString());
        this.hasOptions = true;
    }

    public String getExecutablePath() {
        return this.options.get("executablePath");
    }

    public void setExecutablePath(String executablePath) {
        this.options.put("executablePath", executablePath);
        this.hasOptions = true;
    }

    public boolean isTimeoutSet() {
        String value = this.options.get("timeoutInSeconds");
        return value != null;
    }

    public boolean isCommandLineFlagsSet() {
        String value = this.options.get("commandLineFlags");
        return value != null;
    }

    public String getCommandLineFlags() {
        return this.options.get("commandLineFlags");
    }

    public int getTimeoutInSeconds() {
        String value = this.options.get("timeoutInSeconds");
        if (value == null) {
            return 1800;
        }
        return Integer.parseInt(value);
    }

    public boolean isAvoidingProxy() {
        return this.is("avoidProxy");
    }

    public void setAvoidProxy(boolean avoidProxy) {
        this.set("avoidProxy", avoidProxy);
    }

    public ProxyPac getProxyConfig() {
        String raw = this.get("proxy");
        if (raw == null) {
            return null;
        }
        try {
            return (ProxyPac)new JsonToBeanConverter().convert(ProxyPac.class, (Object)raw);
        }
        catch (Exception e) {
            throw new SeleniumException("Unable to retrieve proxy configuration", e);
        }
    }

    public boolean isEnsuringCleanSession() {
        return this.is("ensureCleanSession");
    }

    public boolean is(String key) {
        String value = this.options.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public String get(String key) {
        return this.options.get(key);
    }

    public File getFile(String key) {
        String value = this.options.get(key);
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.options.put(key, null);
        } else {
            this.options.put(key, value.toString());
        }
    }

    public void setSafely(String key, Object value) {
        if (value == null) {
            return;
        }
        this.set(key, value);
    }

    public String toString() {
        return this.serialize();
    }
}

