/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.rest.Handler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDriverHandler
implements Handler,
Callable<ResultType> {
    protected final DriverSessions sessions;
    protected SessionId sessionId;

    public WebDriverHandler(DriverSessions sessions) {
        this.sessions = sessions;
    }

    @Override
    public final ResultType handle() throws Exception {
        FutureTask<ResultType> future = new FutureTask<ResultType>(this);
        try {
            return this.sessions.get(this.sessionId).execute(future);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = new SessionId(sessionId);
    }

    public String getSessionId() {
        return this.sessionId.toString();
    }

    public String getScreenshot() {
        Session session = this.sessions.get(this.sessionId);
        return session != null ? session.getAndClearScreenshot() : null;
    }

    protected WebDriver getDriver() {
        Session session = this.sessions.get(this.sessionId);
        return session.getDriver();
    }

    protected KnownElements getKnownElements() {
        return this.sessions.get(this.sessionId).getKnownElements();
    }

    protected Response newResponse() {
        return new Response(this.sessionId);
    }

    protected SessionId getRealSessionId() {
        return this.sessionId;
    }

    public void execute(FutureTask<?> task) throws Exception {
        Session session = this.sessions.get(this.sessionId);
        if (session != null) {
            session.execute(task);
        } else {
            task.run();
        }
    }
}

