/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import junit.framework.TestCase;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverSessions;

public class DriverSessionTest
extends TestCase {
    public void testShouldRegisterCorrectDefaultsOnMac() {
        DriverFactory factory = new DriverFactory();
        new DriverSessions(Platform.MAC, factory);
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.chrome()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.firefox()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.htmlUnit()));
        DriverSessionTest.assertFalse((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.internetExplorer()));
    }

    public void testShouldRegisterCorrectDefaultsOnLinux() {
        DriverFactory factory = new DriverFactory();
        new DriverSessions(Platform.LINUX, factory);
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.chrome()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.firefox()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.htmlUnit()));
        DriverSessionTest.assertFalse((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.internetExplorer()));
    }

    public void testShouldRegisterCorrectDefaultsOnWindows() {
        DriverFactory factory = new DriverFactory();
        new DriverSessions(Platform.VISTA, factory);
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.chrome()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.firefox()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.htmlUnit()));
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)DesiredCapabilities.internetExplorer()));
    }

    public void testShouldBeAbleToRegisterOwnDriver() {
        DriverFactory factory = new DriverFactory();
        DriverSessions sessions = new DriverSessions(Platform.VISTA, factory);
        DesiredCapabilities capabilities = new DesiredCapabilities("foo", "1", Platform.ANY);
        sessions.registerDriver((Capabilities)capabilities, AbstractDriver.class);
        DriverSessionTest.assertTrue((boolean)factory.hasMappingFor((Capabilities)capabilities));
    }

    public static abstract class AbstractDriver
    implements WebDriver {
    }
}

