/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.server.RobotRetriever;

public class CaptureScreenshotToStringCommand {
    public static final String ID = "captureScreenshotToString";
    private static final Log LOGGER = LogFactory.getLog(CaptureScreenshotToStringCommand.class);

    public String execute() {
        try {
            return "OK," + this.captureAndEncodeSystemScreenshot();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Problem capturing a screenshot to string", (Throwable)e);
            return "ERROR: Problem capturing a screenshot to string: " + e.getMessage();
        }
    }

    public String captureAndEncodeSystemScreenshot() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        Robot robot = RobotRetriever.getRobot();
        Rectangle captureSize = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        BufferedImage bufferedImage = robot.createScreenCapture(captureSize);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", outStream);
        byte[] encodedData = Base64.encodeBase64((byte[])outStream.toByteArray());
        return new String(encodedData);
    }
}

