/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.LogTo;
import org.openqa.selenium.remote.server.rest.Handler;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.ResultConfig;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlMapper {
    private Map<ResultType, Renderer> globals = new LinkedHashMap<ResultType, Renderer>();
    private Set<ResultConfig> configs = new LinkedHashSet<ResultConfig>();
    private final DriverSessions sessions;
    private LogTo logger;

    public UrlMapper(DriverSessions sessions, LogTo logger) {
        this.sessions = sessions;
        this.logger = logger;
    }

    public ResultConfig bind(String url, Class<? extends Handler> handlerClazz) {
        ResultConfig config = new ResultConfig(url, handlerClazz, this.sessions, this.logger);
        this.configs.add(config);
        for (Map.Entry<ResultType, Renderer> entry : this.globals.entrySet()) {
            config.on(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public ResultConfig getConfig(String url) throws Exception {
        for (ResultConfig config : this.configs) {
            if (!config.isFor(url)) continue;
            return config;
        }
        return null;
    }

    public void addGlobalHandler(ResultType type, Renderer renderer) {
        this.globals.put(type, renderer);
        for (ResultConfig config : this.configs) {
            config.on(type, renderer);
        }
    }
}

