/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.security.InvalidParameterException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSlot {
    private static final Logger log = Logger.getLogger(TestSlot.class.getName());
    private final Map<String, Object> capabilities;
    private final RemoteProxy proxy;
    private final CapabilityMatcher matcher;
    private TestSession currentSession;
    private final Lock lock = new ReentrantLock();
    boolean beingReleased = false;
    private boolean showWarning = false;

    public TestSlot(RemoteProxy proxy, Map<String, Object> capabilities) {
        this.proxy = proxy;
        CapabilityMatcher c = proxy.getCapabilityHelper();
        if (c == null) {
            throw new InvalidParameterException("the proxy needs to have a valid capabilityMatcher to support have some testslots attached to it");
        }
        this.matcher = proxy.getCapabilityHelper();
        this.capabilities = capabilities;
    }

    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    public RemoteProxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestSession getNewSession(Map<String, Object> desiredCapabilities) {
        try {
            this.lock.lock();
            if (this.currentSession != null) {
                TestSession testSession = null;
                return testSession;
            }
            if (this.matches(desiredCapabilities)) {
                TestSession session;
                this.currentSession = session = new TestSession(this, desiredCapabilities);
                TestSession testSession = session;
                return testSession;
            }
            TestSession testSession = null;
            return testSession;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean matches(Map<String, Object> desiredCapabilities) {
        return this.matcher.matches(this.capabilities, desiredCapabilities);
    }

    public TestSession getSession() {
        return this.currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startReleaseProcess() {
        try {
            this.lock.lock();
            if (this.beingReleased) {
                boolean bl = false;
                return bl;
            }
            this.beingReleased = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishReleaseProcess() {
        try {
            this.lock.lock();
            this.currentSession = null;
            this.beingReleased = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _release() {
        if (this.currentSession == null) {
            return;
        }
        boolean okToContinue = this.startReleaseProcess();
        if (!okToContinue) {
            return;
        }
        try {
            if (this.proxy instanceof TestSessionListener) {
                if (this.showWarning && this.proxy.getMaxNumberOfConcurrentTestSessions() != 1) {
                    log.warning("WARNING : using a afterSession on a proxy that can support multiple tests is risky.");
                    this.showWarning = false;
                }
                ((TestSessionListener)((Object)this.proxy)).afterSession(this.currentSession);
            }
        }
        catch (Throwable t) {
            log.severe("Error running afterSession for " + this.currentSession + " the test slot is now dead.");
            t.printStackTrace();
            return;
        }
        String internalKey = this.currentSession == null ? null : this.currentSession.getInternalKey();
        try {
            this.proxy.getRegistry().getLock().lock();
            this.finishReleaseProcess();
            this.proxy.getRegistry().release(internalKey);
        }
        finally {
            this.proxy.getRegistry().getLock().unlock();
        }
    }

    public void forceRelease() {
        if (this.currentSession == null) {
            return;
        }
        String internalKey = this.currentSession.getInternalKey();
        this.currentSession = null;
        this.proxy.getRegistry().release(internalKey);
        this.beingReleased = false;
    }

    public void release() {
        new Thread(new Runnable(){

            public void run() {
                TestSlot.this._release();
            }
        }).start();
    }

    public String toString() {
        return this.currentSession == null ? "no session" : this.currentSession.toString();
    }
}

