/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.openqa.selenium.Beta;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.network.AddInterceptParameters;
import org.openqa.selenium.bidi.network.BytesValue;
import org.openqa.selenium.bidi.network.ContinueRequestParameters;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.bidi.network.InterceptPhase;
import org.openqa.selenium.bidi.network.RequestData;
import org.openqa.selenium.remote.Network;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

@Beta
class RemoteNetwork
implements Network {
    private final BiDi biDi;
    private final org.openqa.selenium.bidi.module.Network network;
    private final Map<Long, AuthDetails> authHandlers = new ConcurrentHashMap<Long, AuthDetails>();
    private final Map<Long, RequestDetails> requestHandlers = new ConcurrentHashMap<Long, RequestDetails>();
    private final AtomicLong callBackId = new AtomicLong(1L);

    public RemoteNetwork(WebDriver driver) {
        this.biDi = ((HasBiDi)driver).getBiDi();
        this.network = new org.openqa.selenium.bidi.module.Network(driver);
        this.interceptAuthTraffic();
        this.interceptRequest();
    }

    private void interceptAuthTraffic() {
        this.network.addIntercept(new AddInterceptParameters(InterceptPhase.AUTH_REQUIRED));
        this.network.onAuthRequired(responseDetails -> {
            String requestId = responseDetails.getRequest().getRequestId();
            URI uri = URI.create(responseDetails.getRequest().getUrl());
            Optional<UsernameAndPassword> authCredentials = this.getAuthCredentials(uri);
            if (authCredentials.isPresent()) {
                this.network.continueWithAuth(requestId, authCredentials.get());
                return;
            }
            this.network.continueWithAuthNoCredentials(requestId);
        });
    }

    private Optional<UsernameAndPassword> getAuthCredentials(URI uri) {
        return this.authHandlers.values().stream().filter(authDetails -> authDetails.getFilter().test(uri)).map(AuthDetails::getUsernameAndPassword).findFirst();
    }

    private void interceptRequest() {
        this.network.addIntercept(new AddInterceptParameters(InterceptPhase.BEFORE_REQUEST_SENT));
        this.network.onBeforeRequestSent(beforeRequestSent -> {
            String requestId = beforeRequestSent.getRequest().getRequestId();
            URI uri = URI.create(beforeRequestSent.getRequest().getUrl());
            ContinueRequestParameters continueRequestParameters = new ContinueRequestParameters(requestId);
            Optional<UnaryOperator<HttpRequest>> requestHandler = this.getRequestHandler(uri);
            if (requestHandler.isPresent()) {
                Contents.Supplier content;
                RequestData interceptedRequest = beforeRequestSent.getRequest();
                HttpRequest originalRequest = new HttpRequest(HttpMethod.getHttpMethod((String)interceptedRequest.getMethod()), interceptedRequest.getUrl());
                interceptedRequest.getHeaders().forEach(header -> originalRequest.addHeader(header.getName(), header.getValue().getValue()));
                HttpRequest modifiedRequest = (HttpRequest)requestHandler.get().apply(originalRequest);
                continueRequestParameters.method(modifiedRequest.getMethod());
                if (!uri.toString().equals(modifiedRequest.getUri())) {
                    continueRequestParameters.url(modifiedRequest.getUri());
                }
                ArrayList<Header> headerList = new ArrayList<Header>();
                modifiedRequest.forEachHeader((name, value) -> headerList.add(new Header((String)name, new BytesValue(BytesValue.Type.STRING, (String)value))));
                if (!headerList.isEmpty()) {
                    continueRequestParameters.headers(headerList);
                }
                if ((content = modifiedRequest.getContent()).length() > 0L) {
                    continueRequestParameters.body(new BytesValue(BytesValue.Type.STRING, Contents.utf8String((Contents.Supplier)content)));
                }
            }
            this.network.continueRequest(continueRequestParameters);
        });
    }

    private Optional<UnaryOperator<HttpRequest>> getRequestHandler(URI uri) {
        return this.requestHandlers.values().stream().filter(requestDetails -> requestDetails.getFilter().test(uri)).map(RequestDetails::getHandler).findFirst();
    }

    @Override
    public long addAuthenticationHandler(UsernameAndPassword usernameAndPassword) {
        return this.addAuthenticationHandler(url -> true, usernameAndPassword);
    }

    @Override
    public long addAuthenticationHandler(Predicate<URI> filter, UsernameAndPassword usernameAndPassword) {
        long id = this.callBackId.incrementAndGet();
        this.authHandlers.put(id, new AuthDetails(filter, usernameAndPassword));
        return id;
    }

    @Override
    public void removeAuthenticationHandler(long id) {
        this.authHandlers.remove(id);
    }

    @Override
    public void clearAuthenticationHandlers() {
        this.authHandlers.clear();
    }

    @Override
    public long addRequestHandler(Predicate<URI> filter, UnaryOperator<HttpRequest> handler) {
        long id = this.callBackId.incrementAndGet();
        this.requestHandlers.put(id, new RequestDetails(filter, handler));
        return id;
    }

    @Override
    public void removeRequestHandler(long id) {
        this.requestHandlers.remove(id);
    }

    @Override
    public void clearRequestHandlers() {
        this.requestHandlers.clear();
    }

    private class AuthDetails {
        private final Predicate<URI> filter;
        private final UsernameAndPassword usernameAndPassword;

        public AuthDetails(Predicate<URI> filter, UsernameAndPassword usernameAndPassword) {
            this.filter = filter;
            this.usernameAndPassword = usernameAndPassword;
        }

        public Predicate<URI> getFilter() {
            return this.filter;
        }

        public UsernameAndPassword getUsernameAndPassword() {
            return this.usernameAndPassword;
        }
    }

    private class RequestDetails {
        private final Predicate<URI> filter;
        private final UnaryOperator<HttpRequest> handler;

        public RequestDetails(Predicate<URI> filter, UnaryOperator<HttpRequest> handler) {
            this.filter = filter;
            this.handler = handler;
        }

        public Predicate<URI> getFilter() {
            return this.filter;
        }

        public UnaryOperator<HttpRequest> getHandler() {
            return this.handler;
        }
    }
}

