/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryAttributeMap;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetrySpan
extends OpenTelemetryContext
implements AutoCloseable,
Span {
    private final io.opentelemetry.api.trace.Span span;
    private final Scope scope;
    private static final Map<Status.Kind, StatusCode> statuses = Map.ofEntries(Map.entry(Status.Kind.ABORTED, StatusCode.ERROR), Map.entry(Status.Kind.CANCELLED, StatusCode.ERROR), Map.entry(Status.Kind.NOT_FOUND, StatusCode.ERROR), Map.entry(Status.Kind.OK, StatusCode.OK), Map.entry(Status.Kind.RESOURCE_EXHAUSTED, StatusCode.ERROR), Map.entry(Status.Kind.UNKNOWN, StatusCode.ERROR), Map.entry(Status.Kind.INVALID_ARGUMENT, StatusCode.ERROR), Map.entry(Status.Kind.DEADLINE_EXCEEDED, StatusCode.ERROR), Map.entry(Status.Kind.ALREADY_EXISTS, StatusCode.ERROR), Map.entry(Status.Kind.PERMISSION_DENIED, StatusCode.ERROR), Map.entry(Status.Kind.OUT_OF_RANGE, StatusCode.ERROR), Map.entry(Status.Kind.UNIMPLEMENTED, StatusCode.ERROR), Map.entry(Status.Kind.INTERNAL, StatusCode.ERROR), Map.entry(Status.Kind.UNAVAILABLE, StatusCode.ERROR), Map.entry(Status.Kind.UNAUTHENTICATED, StatusCode.ERROR));

    public OpenTelemetrySpan(Tracer tracer, Context context, io.opentelemetry.api.trace.Span span, Scope scope) {
        super(tracer, context);
        this.span = (io.opentelemetry.api.trace.Span)Require.nonNull((String)"Span", (Object)span);
        this.scope = (Scope)Require.nonNull((String)"Scope", (Object)scope);
    }

    @Override
    public Span setName(String name) {
        this.span.updateName((String)Require.nonNull((String)"Name to update to", (Object)name));
        return this;
    }

    @Override
    public Span setAttribute(String key, boolean value) {
        this.span.setAttribute((String)Require.nonNull((String)"Key", (Object)key), value);
        return this;
    }

    @Override
    public Span setAttribute(String key, Number value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        if (value instanceof Double || value instanceof Float) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            this.span.setAttribute(key, value.longValue());
        }
        return this;
    }

    @Override
    public Span setAttribute(String key, String value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addEvent(String name) {
        Require.nonNull((String)"Name", (Object)name);
        this.span.addEvent(name);
        return this;
    }

    @Override
    public Span addEvent(String name, AttributeMap attributeMap) {
        Require.nonNull((String)"Name", (Object)name);
        Require.nonNull((String)"Event Attribute Map", (Object)attributeMap);
        this.span.addEvent(name, ((OpenTelemetryAttributeMap)attributeMap).build());
        return this;
    }

    @Override
    public Span setStatus(Status status) {
        Require.nonNull((String)"Status", (Object)status);
        StatusCode statusCode = statuses.get((Object)status.getKind());
        if (statusCode == null) {
            throw new IllegalArgumentException("Unrecognized status kind: " + String.valueOf((Object)status.getKind()));
        }
        this.span.setStatus(statusCode, "Kind: " + status.getKind().toString() + " Description:" + status.getDescription());
        return this;
    }

    @Override
    public void close() {
        this.scope.close();
        this.span.end();
    }

    @Override
    public String toString() {
        SpanContext context = this.span.getSpanContext();
        return "OpenTelemetrySpan{traceId=" + context.getTraceId() + ",spanId=" + context.getSpanId() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OpenTelemetryContext && !(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        if (!(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        OpenTelemetrySpan that = (OpenTelemetrySpan)o;
        SpanContext thisContext = this.span.getSpanContext();
        SpanContext thatContext = that.span.getSpanContext();
        return Objects.equals(thisContext.getSpanId(), thatContext.getSpanId()) && Objects.equals(thisContext.getTraceId(), thatContext.getTraceId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.span);
    }
}

