/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.ExecutableFinder;

public class DriverService
implements Closeable {
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(20L);
    private final ExecutorService executorService = Executors.newFixedThreadPool(2, r -> {
        Thread thread = new Thread(r);
        thread.setName("Driver Service Executor");
        thread.setDaemon(true);
        return thread;
    });
    private final URL url;
    private final ReentrantLock lock = new ReentrantLock();
    private final String executable;
    private final Duration timeout;
    private final List<String> args;
    private final Map<String, String> environment;
    protected CommandLine process = null;
    private OutputStream outputStream = System.err;

    protected DriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        this.executable = executable.getCanonicalPath();
        this.timeout = timeout;
        this.args = args;
        this.environment = environment;
        this.url = this.getUrl(port);
    }

    protected static File findExecutable(String exeName, String exeProperty, String exeDocs, String exeDownload) {
        String defaultPath = new ExecutableFinder().find(exeName);
        String exePath = System.getProperty(exeProperty, defaultPath);
        Require.state((String)"The path to the driver executable", (Object)exePath).nonNull("The path to the driver executable must be set by the %s system property; for more information, see %s. The latest version can be downloaded from %s", new Object[]{exeProperty, exeDocs, exeDownload});
        File exe = new File(exePath);
        DriverService.checkExecutable(exe);
        return exe;
    }

    protected static void checkExecutable(File exe) {
        Require.state((String)"The driver executable", (File)exe).isFile();
        Require.stateCondition((boolean)exe.canExecute(), (String)"It must be an executable file: %s", (Object[])new Object[]{exe});
    }

    protected List<String> getArgs() {
        return this.args;
    }

    protected Map<String, String> getEnvironment() {
        return this.environment;
    }

    protected URL getUrl(int port) throws IOException {
        return new URL(String.format("http://localhost:%d", port));
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.process != null && this.process.isRunning();
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            this.process = new CommandLine(this.executable, this.args.toArray(new String[0]));
            this.process.setEnvironmentVariables(this.environment);
            this.process.copyOutputTo(this.getOutputStream());
            this.process.executeAsync();
            CompletableFuture<StartOrDie> serverStarted = CompletableFuture.supplyAsync(() -> {
                this.waitUntilAvailable();
                return StartOrDie.SERVER_STARTED;
            }, this.executorService);
            CompletableFuture<StartOrDie> processFinished = CompletableFuture.supplyAsync(() -> {
                try {
                    this.process.waitFor(this.getTimeout().toMillis());
                }
                catch (TimeoutException ex) {
                    return StartOrDie.PROCESS_IS_ACTIVE;
                }
                return StartOrDie.PROCESS_DIED;
            }, this.executorService);
            try {
                StartOrDie status = (StartOrDie)((Object)CompletableFuture.anyOf(serverStarted, processFinished).get(this.getTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS));
                if (status == StartOrDie.SERVER_STARTED) {
                    processFinished.cancel(true);
                } else if (status == StartOrDie.PROCESS_DIED) {
                    this.process = null;
                    throw new WebDriverException("Driver server process died prematurely.");
                }
            }
            catch (ExecutionException | java.util.concurrent.TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to start.", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException("Timed out waiting for driver server to start.", (Throwable)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Duration getTimeout() {
        return this.timeout;
    }

    protected void waitUntilAvailable() {
        try {
            URL status = new URL(this.url.toString() + "/status");
            new UrlChecker().waitUntilAvailable(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS, new URL[]{status});
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Driver server status URL is malformed.", (Throwable)e);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for driver server to start.", (Throwable)e);
        }
    }

    public void stop() {
        this.lock.lock();
        WebDriverException toThrow = null;
        try {
            if (this.process == null) {
                return;
            }
            if (this.hasShutdownEndpoint()) {
                try {
                    URL killUrl = new URL(this.url.toString() + "/shutdown");
                    new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
                }
                catch (MalformedURLException e) {
                    toThrow = new WebDriverException((Throwable)e);
                }
                catch (UrlChecker.TimeoutException e) {
                    toThrow = new WebDriverException("Timed out waiting for driver server to shutdown.", (Throwable)e);
                }
            }
            this.process.destroy();
            if (this.getOutputStream() instanceof FileOutputStream) {
                try {
                    this.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.process = null;
            this.lock.unlock();
            this.executorService.shutdownNow();
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    protected boolean hasShutdownEndpoint() {
        return true;
    }

    public void sendOutputTo(OutputStream outputStream) {
        this.outputStream = (OutputStream)Require.nonNull((String)"Output stream", (Object)outputStream);
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }

    public static abstract class Builder<DS extends DriverService, B extends Builder<?, ?>> {
        private int port = 0;
        private File exe = null;
        private Map<String, String> environment = Collections.emptyMap();
        private File logFile;
        private Duration timeout;

        public abstract int score(Capabilities var1);

        public B usingDriverExecutable(File file) {
            Require.nonNull((String)"Driver executable file", (Object)file);
            DriverService.checkExecutable(file);
            this.exe = file;
            return (B)this;
        }

        public B usingPort(int port) {
            this.port = Require.nonNegative((String)"Port number", (Integer)port);
            return (B)this;
        }

        protected int getPort() {
            return this.port;
        }

        public B usingAnyFreePort() {
            this.port = 0;
            return (B)this;
        }

        @Beta
        public B withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return (B)this;
        }

        public B withLogFile(File logFile) {
            this.logFile = logFile;
            return (B)this;
        }

        protected File getLogFile() {
            return this.logFile;
        }

        public B withTimeout(Duration timeout) {
            this.timeout = timeout;
            return (B)this;
        }

        protected Duration getDefaultTimeout() {
            return DEFAULT_TIMEOUT;
        }

        public DS build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = this.findDefaultExecutable();
            }
            if (this.timeout == null) {
                this.timeout = this.getDefaultTimeout();
            }
            List<String> args = this.createArgs();
            DS service = this.createDriverService(this.exe, this.port, this.timeout, args, this.environment);
            this.port = 0;
            return service;
        }

        protected abstract File findDefaultExecutable();

        protected abstract List<String> createArgs();

        protected abstract DS createDriverService(File var1, int var2, Duration var3, List<String> var4, Map<String, String> var5);
    }

    private static enum StartOrDie {
        SERVER_STARTED,
        PROCESS_IS_ACTIVE,
        PROCESS_DIED;

    }
}

