/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpCommandCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public enum Dialect {
    OSS{

        @Override
        public CommandCodec<HttpRequest> getCommandCodec() {
            return new JsonHttpCommandCodec();
        }

        @Override
        public ResponseCodec<HttpResponse> getResponseCodec() {
            return new JsonHttpResponseCodec();
        }

        @Override
        public String getEncodedElementKey() {
            return "ELEMENT";
        }

        @Override
        public String getShadowRootElementKey() {
            return "shadow-6066-11e4-a52e-4f735466cecf";
        }
    }
    ,
    W3C{

        @Override
        public CommandCodec<HttpRequest> getCommandCodec() {
            return new W3CHttpCommandCodec();
        }

        @Override
        public ResponseCodec<HttpResponse> getResponseCodec() {
            return new W3CHttpResponseCodec();
        }

        @Override
        public String getEncodedElementKey() {
            return "element-6066-11e4-a52e-4f735466cecf";
        }

        @Override
        public String getShadowRootElementKey() {
            return "shadow-6066-11e4-a52e-4f735466cecf";
        }
    };


    public abstract CommandCodec<HttpRequest> getCommandCodec();

    public abstract ResponseCodec<HttpResponse> getResponseCodec();

    public abstract String getEncodedElementKey();

    public abstract String getShadowRootElementKey();
}

