/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.internal.Require;

public abstract class AbstractDriverOptions<DO extends AbstractDriverOptions>
extends MutableCapabilities {
    public DO setPageLoadStrategy(PageLoadStrategy strategy) {
        this.setCapability("pageLoadStrategy", Require.nonNull((String)"Page load strategy", (Object)strategy));
        return (DO)((Object)this);
    }

    public DO setUnhandledPromptBehaviour(UnexpectedAlertBehaviour behaviour) {
        this.setCapability("unhandledPromptBehavior", Require.nonNull((String)"Unhandled prompt behavior", (Object)behaviour));
        return (DO)((Object)this);
    }

    public DO setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
        return (DO)((Object)this);
    }

    public DO setStrictFileInteractability(boolean strictFileInteractability) {
        this.setCapability("strictFileInteractability", strictFileInteractability);
        return (DO)((Object)this);
    }

    public DO setProxy(Proxy proxy) {
        this.setCapability("proxy", Require.nonNull((String)"Proxy", (Object)proxy));
        return (DO)((Object)this);
    }

    public Set<String> getCapabilityNames() {
        TreeSet<String> names = new TreeSet<String>(super.getCapabilityNames());
        names.addAll(this.getExtraCapabilityNames());
        return Collections.unmodifiableSet(names);
    }

    protected abstract Set<String> getExtraCapabilityNames();

    public Object getCapability(String capabilityName) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        if (this.getExtraCapabilityNames().contains(capabilityName)) {
            return this.getExtraCapability(capabilityName);
        }
        return super.getCapability(capabilityName);
    }

    protected abstract Object getExtraCapability(String var1);

    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap(super.asMap());
        this.getExtraCapabilityNames().forEach(name -> toReturn.put(name, this.getCapability((String)name)));
        return Collections.unmodifiableMap(toReturn);
    }
}

