/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.tracing.Propagator;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.opentelemetry.JaegerTracing;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryPropagator;

public class OpenTelemetryTracer
implements Tracer {
    private static final Logger LOG = Logger.getLogger(OpenTelemetryTracer.class.getName());
    private static volatile OpenTelemetryTracer singleton;
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final OpenTelemetryPropagator telemetryPropagator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenTelemetryTracer getInstance() {
        OpenTelemetryTracer localTracer = singleton;
        if (localTracer != null) return localTracer;
        Class<OpenTelemetryTracer> clazz = OpenTelemetryTracer.class;
        synchronized (OpenTelemetryTracer.class) {
            localTracer = singleton;
            if (localTracer != null) return localTracer;
            singleton = localTracer = OpenTelemetryTracer.createTracer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localTracer;
        }
    }

    private static OpenTelemetryTracer createTracer() {
        LOG.info("Using OpenTelemetry for tracing");
        LinkedList<SpanProcessor> exporters = new LinkedList<SpanProcessor>();
        exporters.add(SimpleSpanProcessor.create((SpanExporter)new SpanExporter(){

            public CompletableResultCode export(Collection<SpanData> spans) {
                spans.forEach(span -> {
                    LOG.fine(String.valueOf(span));
                    String traceId = span.getTraceId();
                    String spanId = span.getSpanId();
                    StatusData status = span.getStatus();
                    List eventList = span.getEvents();
                    eventList.forEach(event -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("eventTime", event.getEpochNanos());
                        map.put("traceId", traceId);
                        map.put("spanId", spanId);
                        map.put("spanKind", span.getKind().toString());
                        map.put("eventName", event.getName());
                        Attributes attributes = event.getAttributes();
                        map.put("attributes", attributes.asMap());
                        String jsonString = OpenTelemetryTracer.getJsonString(map);
                        if (status.getStatusCode() == StatusCode.ERROR) {
                            LOG.log(Level.WARNING, jsonString);
                        } else {
                            LOG.log(Level.FINE, jsonString);
                        }
                    });
                });
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode flush() {
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode shutdown() {
                return CompletableResultCode.ofSuccess();
            }
        }));
        Optional<SpanExporter> maybeJaeger = JaegerTracing.findJaegerExporter();
        maybeJaeger.ifPresent(exporter -> exporters.add(SimpleSpanProcessor.create((SpanExporter)exporter)));
        ContextPropagators propagators = ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance());
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor(SpanProcessor.composite(exporters)).build();
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(propagators).buildAndRegisterGlobal();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> openTelemetrySdk.getTracerManagement().shutdown()));
        return new OpenTelemetryTracer(openTelemetrySdk.getTracer("default"), propagators.getTextMapPropagator());
    }

    private static String getJsonString(Map<String, Object> map) {
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = new Json().newOutput((Appendable)text).setPrettyPrint(false);){
            json.write(map);
            text.append('\n');
        }
        return text.toString();
    }

    public OpenTelemetryTracer(io.opentelemetry.api.trace.Tracer tracer, TextMapPropagator textMapPropagator) {
        this.tracer = (io.opentelemetry.api.trace.Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.telemetryPropagator = new OpenTelemetryPropagator(tracer, (TextMapPropagator)Require.nonNull((String)"Formatter", (Object)textMapPropagator));
    }

    @Override
    public TraceContext getCurrentContext() {
        return new OpenTelemetryContext(this.tracer, Context.current());
    }

    @Override
    public Propagator getPropagator() {
        return this.telemetryPropagator;
    }
}

