/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetrySpan
extends OpenTelemetryContext
implements AutoCloseable,
Span {
    private final io.opentelemetry.api.trace.Span span;
    private final Scope scope;
    private static final Map<Status.Kind, StatusCode> statuses = new ImmutableMap.Builder().put((Object)Status.Kind.ABORTED, (Object)StatusCode.ERROR).put((Object)Status.Kind.CANCELLED, (Object)StatusCode.ERROR).put((Object)Status.Kind.NOT_FOUND, (Object)StatusCode.ERROR).put((Object)Status.Kind.OK, (Object)StatusCode.OK).put((Object)Status.Kind.RESOURCE_EXHAUSTED, (Object)StatusCode.ERROR).put((Object)Status.Kind.UNKNOWN, (Object)StatusCode.ERROR).put((Object)Status.Kind.INVALID_ARGUMENT, (Object)StatusCode.ERROR).put((Object)Status.Kind.DEADLINE_EXCEEDED, (Object)StatusCode.ERROR).put((Object)Status.Kind.ALREADY_EXISTS, (Object)StatusCode.ERROR).put((Object)Status.Kind.PERMISSION_DENIED, (Object)StatusCode.ERROR).put((Object)Status.Kind.OUT_OF_RANGE, (Object)StatusCode.ERROR).put((Object)Status.Kind.UNIMPLEMENTED, (Object)StatusCode.ERROR).put((Object)Status.Kind.INTERNAL, (Object)StatusCode.ERROR).put((Object)Status.Kind.UNAVAILABLE, (Object)StatusCode.ERROR).put((Object)Status.Kind.UNAUTHENTICATED, (Object)StatusCode.ERROR).build();

    public OpenTelemetrySpan(Tracer tracer, Context context, io.opentelemetry.api.trace.Span span, Scope scope) {
        super(tracer, context);
        this.span = (io.opentelemetry.api.trace.Span)Require.nonNull((String)"Span", (Object)span);
        this.scope = (Scope)Require.nonNull((String)"Scope", (Object)scope);
    }

    @Override
    public Span setName(String name) {
        this.span.updateName((String)Require.nonNull((String)"Name to update to", (Object)name));
        return this;
    }

    @Override
    public Span setAttribute(String key, boolean value) {
        this.span.setAttribute((String)Require.nonNull((String)"Key", (Object)key), value);
        return this;
    }

    @Override
    public Span setAttribute(String key, Number value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        Class unwrapped = Primitives.unwrap(value.getClass());
        if (Double.TYPE.equals(unwrapped) || Float.TYPE.equals(unwrapped)) {
            this.span.setAttribute(key, value.doubleValue());
        } else {
            this.span.setAttribute(key, value.longValue());
        }
        return this;
    }

    @Override
    public Span setAttribute(String key, String value) {
        Require.nonNull((String)"Key", (Object)key);
        Require.nonNull((String)"Value", (Object)value);
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addEvent(String name) {
        Require.nonNull((String)"Name", (Object)name);
        this.span.addEvent(name);
        return this;
    }

    @Override
    public Span addEvent(String name, Map<String, EventAttributeValue> attributeMap) {
        Require.nonNull((String)"Name", (Object)name);
        Require.nonNull((String)"Event Attribute Map", attributeMap);
        AttributesBuilder otAttributes = Attributes.builder();
        attributeMap.forEach((key, value) -> {
            Require.nonNull((String)"Event Attribute Value", (Object)value);
            switch (value.getAttributeType()) {
                case BOOLEAN: {
                    otAttributes.put(key, value.getBooleanValue().booleanValue());
                    break;
                }
                case BOOLEAN_ARRAY: {
                    otAttributes.put(key, value.getBooleanArrayValue());
                    break;
                }
                case DOUBLE: {
                    otAttributes.put(key, value.getNumberValue().doubleValue());
                    break;
                }
                case DOUBLE_ARRAY: {
                    otAttributes.put(key, value.getDoubleArrayValue());
                    break;
                }
                case LONG: {
                    otAttributes.put(key, value.getNumberValue().longValue());
                    break;
                }
                case LONG_ARRAY: {
                    otAttributes.put(key, value.getLongArrayValue());
                    break;
                }
                case STRING: {
                    otAttributes.put(key, value.getStringValue());
                    break;
                }
                case STRING_ARRAY: {
                    otAttributes.put(key, value.getStringArrayValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized event attribute value type: " + (Object)((Object)value.getAttributeType()));
                }
            }
        });
        this.span.addEvent(name, otAttributes.build());
        return this;
    }

    @Override
    public Span setStatus(Status status) {
        Require.nonNull((String)"Status", (Object)status);
        StatusCode statusCode = statuses.get((Object)status.getKind());
        if (statusCode == null) {
            throw new IllegalArgumentException("Unrecognized status kind: " + (Object)((Object)status.getKind()));
        }
        this.span.setStatus(statusCode, "Kind: " + status.getKind().toString() + " Description:" + status.getDescription());
        return this;
    }

    @Override
    public void close() {
        this.scope.close();
        this.span.end();
    }

    @Override
    public String toString() {
        SpanContext context = this.span.getSpanContext();
        return "OpenTelemetrySpan{traceId=" + context.getTraceIdAsHexString() + ",spanId=" + context.getSpanIdAsHexString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OpenTelemetryContext && !(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        if (!(o instanceof OpenTelemetrySpan)) {
            return false;
        }
        OpenTelemetrySpan that = (OpenTelemetrySpan)o;
        SpanContext thisContext = this.span.getSpanContext();
        SpanContext thatContext = that.span.getSpanContext();
        return Objects.equals(thisContext.getSpanIdAsHexString(), thatContext.getSpanIdAsHexString()) && Objects.equals(thisContext.getTraceIdAsHexString(), thatContext.getTraceIdAsHexString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.span);
    }
}

