/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.http.HttpRequest;

public class HttpTracing {
    private HttpTracing() {
    }

    public static SpanContext extract(Tracer tracer, HttpRequest request) {
        return tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpRequestAdapter(request));
    }

    public static void inject(Tracer tracer, Span span, HttpRequest request) {
        Objects.requireNonNull(request, "Request must be set.");
        if (span == null) {
            return;
        }
        span.setTag(Tags.HTTP_METHOD.getKey(), request.getMethod().toString());
        span.setTag(Tags.HTTP_URL.getKey(), request.getUri());
        tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpRequestAdapter(request));
    }

    private static class HttpRequestAdapter
    extends TextMapAdapter {
        public HttpRequestAdapter(HttpRequest request) {
            super(HttpRequestAdapter.asMap(request));
        }

        private static Map<String, String> asMap(HttpRequest request) {
            LinkedHashMap entries = new LinkedHashMap();
            request.getHeaderNames().forEach(name -> request.getHeaders(name).forEach(value -> {
                if (value != null) {
                    entries.put(name, value);
                }
            }));
            return Collections.unmodifiableMap(entries);
        }

        public void put(String key, String value) {
            super.put(key, value);
        }
    }
}

