/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.okhttp;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openqa.selenium.remote.http.ClientConfig;

class CreateOkClient
implements Function<ClientConfig, OkHttpClient> {
    CreateOkClient() {
    }

    @Override
    public OkHttpClient apply(ClientConfig config) {
        Objects.requireNonNull(config, "Client config to use must be set.");
        OkHttpClient.Builder client = new OkHttpClient.Builder().followRedirects(true).followSslRedirects(true).proxy(config.proxy()).readTimeout(config.readTimeout().toMillis(), TimeUnit.MILLISECONDS).connectTimeout(config.connectionTimeout().toMillis(), TimeUnit.MILLISECONDS);
        String info = config.baseUri().getUserInfo();
        if (!Strings.isNullOrEmpty((String)info)) {
            String[] parts = info.split(":", 2);
            String user = parts[0];
            String pass = parts.length > 1 ? parts[1] : null;
            String credentials = Credentials.basic((String)user, (String)pass);
            client.authenticator((route, response) -> {
                if (response.request().header("Authorization") != null) {
                    return null;
                }
                return response.request().newBuilder().header("Authorization", credentials).build();
            });
        }
        client.addNetworkInterceptor(chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            return response.code() == 408 ? response.newBuilder().code(500).message("Server-Side Timeout").build() : response;
        });
        return client.build();
    }
}

