/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.openqa.selenium.json.JsonException;

public class SessionId {
    private final String opaqueKey;

    public SessionId(UUID uuid) {
        this(Objects.requireNonNull(uuid, "Session ID key has not been set.").toString());
    }

    public SessionId(String opaqueKey) {
        this.opaqueKey = Objects.requireNonNull(opaqueKey, "Session ID key has not been set.");
    }

    public String toString() {
        return this.opaqueKey;
    }

    public int hashCode() {
        return this.opaqueKey.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SessionId && this.opaqueKey.equals(((SessionId)obj).opaqueKey);
    }

    private String toJson() {
        return this.opaqueKey;
    }

    private static SessionId fromJson(Object raw) {
        Map map;
        if (raw instanceof String) {
            return new SessionId(String.valueOf(raw));
        }
        if (raw instanceof Map && (map = (Map)raw).get("value") instanceof String) {
            return new SessionId(String.valueOf(map.get("value")));
        }
        throw new JsonException("Unable to coerce session id from " + raw);
    }
}

