/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.target.model;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.openqa.selenium.devtools.target.model.TargetId;
import org.openqa.selenium.json.JsonInput;

public class TargetInfo {
    private final TargetId targetId;
    private final String type;
    private final String title;
    private final String url;
    private final boolean attached;

    public TargetInfo(TargetId id, String type, String title, String url, boolean attached) {
        this.targetId = Objects.requireNonNull(id);
        this.type = Objects.requireNonNull(type);
        this.title = Objects.requireNonNull(title);
        this.url = Objects.requireNonNull(url);
        this.attached = attached;
    }

    private static TargetInfo fromJson(JsonInput input) {
        TargetId id = null;
        String type = null;
        String title = null;
        String url = null;
        boolean attached = false;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "attached": {
                    attached = input.nextBoolean();
                    continue block14;
                }
                case "targetId": {
                    id = (TargetId)input.read((Type)((Object)TargetId.class));
                    continue block14;
                }
                case "title": {
                    title = input.nextString();
                    continue block14;
                }
                case "type": {
                    type = input.nextString();
                    continue block14;
                }
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TargetInfo(id, type, title, url, attached);
    }

    public TargetId getTargetId() {
        return this.targetId;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TargetInfo)) {
            return false;
        }
        TargetInfo that = (TargetInfo)o;
        return this.attached == that.attached && this.targetId.equals(that.targetId) && this.type.equals(that.type) && this.title.equals(that.title) && this.url.equals(that.url);
    }

    public int hashCode() {
        return Objects.hash(this.targetId, this.type, this.title, this.url, this.attached);
    }

    public String toString() {
        return new StringJoiner(", ", TargetInfo.class.getSimpleName() + "[", "]").add("targetId=" + this.targetId).add("type='" + this.type + "'").add("title='" + this.title + "'").add("url='" + this.url + "'").add("attached=" + this.attached).toString();
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"targetId", (Object)this.targetId, (Object)"type", (Object)this.type, (Object)"title", (Object)this.title, (Object)"url", (Object)this.url, (Object)"attached", (Object)this.attached);
    }
}

