/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.security.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MixedContentType;
import org.openqa.selenium.devtools.network.model.SecurityState;
import org.openqa.selenium.json.JsonInput;

public class SecurityStateExplanation {
    private SecurityState securityState;
    private String title;
    private String summary;
    private String description;
    private MixedContentType mixedContentType;
    private List<String> certificate;
    private List<String> recommendations;

    private SecurityStateExplanation(SecurityState securityState, String title, String summary, String description, MixedContentType mixedContentType, List<String> certificate, List<String> recommendations) {
        this.securityState = Objects.requireNonNull(securityState, "'securityState' is required for SecurityStateExplanation");
        this.title = Objects.requireNonNull(title, "'title' is required for SecurityStateExplanation");
        this.summary = Objects.requireNonNull(summary, "'summary' is required for SecurityStateExplanation");
        this.description = Objects.requireNonNull(description, "'description' is required for SecurityStateExplanation");
        this.mixedContentType = Objects.requireNonNull(mixedContentType, "'mixedContentType' is required for SecurityStateExplanation");
        this.certificate = Objects.requireNonNull(certificate, "'certificate' is required for SecurityStateExplanation");
        this.recommendations = recommendations;
    }

    private static SecurityStateExplanation fromJson(JsonInput input) {
        SecurityState securityState = null;
        String title = null;
        String summary = null;
        String description = null;
        MixedContentType mixedContentType = null;
        List certificate = null;
        List recommendations = null;
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "securityState": {
                    securityState = SecurityState.valueOf(input.nextString());
                    continue block18;
                }
                case "title": {
                    title = input.nextString();
                    continue block18;
                }
                case "summary": {
                    summary = input.nextString();
                    continue block18;
                }
                case "description": {
                    description = input.nextString();
                    continue block18;
                }
                case "mixedContentType": {
                    mixedContentType = MixedContentType.fromString(input.nextString());
                    continue block18;
                }
                case "certificate": {
                    certificate = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block18;
                }
                case "recommendations": {
                    recommendations = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block18;
                }
            }
            input.skipValue();
        }
        return new SecurityStateExplanation(securityState, title, summary, description, mixedContentType, certificate, recommendations);
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public MixedContentType getMixedContentType() {
        return this.mixedContentType;
    }

    public List<String> getCertificate() {
        return this.certificate;
    }

    public List<String> getRecommendations() {
        return this.recommendations;
    }
}

