/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.json.JsonInput;

public class SignedExchangeSignature {
    private String label;
    private String signature;
    private String integrity;
    private String certUrl;
    private String certSha256;
    private String validityUrl;
    private MonotonicTime date;
    private MonotonicTime expires;
    private List<String> certificates;

    private SignedExchangeSignature(String label, String signature, String integrity, String certUrl, String certSha256, String validityUrl, MonotonicTime date, MonotonicTime expires, List<String> certificates) {
        this.label = Objects.requireNonNull(label, "'label' is required for SignedExchangeSignature");
        this.signature = Objects.requireNonNull(signature, "'signature' is required for SignedExchangeSignature");
        this.integrity = Objects.requireNonNull(integrity, "'integrity' is required for SignedExchangeSignature");
        this.certUrl = certUrl;
        this.certSha256 = certSha256;
        this.validityUrl = Objects.requireNonNull(validityUrl, "'validityUrl' is required for SignedExchangeSignature");
        this.date = Objects.requireNonNull(date, "'date' is required for SignedExchangeSignature");
        this.expires = Objects.requireNonNull(expires, "'expires' is required for SignedExchangeSignature");
        this.certificates = certificates;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(String integrity) {
        this.integrity = integrity;
    }

    public String getCertUrl() {
        return this.certUrl;
    }

    public void setCertUrl(String certUrl) {
        this.certUrl = certUrl;
    }

    public String getCertSha256() {
        return this.certSha256;
    }

    public void setCertSha256(String certSha256) {
        this.certSha256 = certSha256;
    }

    public String getValidityUrl() {
        return this.validityUrl;
    }

    public void setValidityUrl(String validityUrl) {
        this.validityUrl = validityUrl;
    }

    public MonotonicTime getDate() {
        return this.date;
    }

    public void setDate(MonotonicTime date) {
        this.date = date;
    }

    public MonotonicTime getExpires() {
        return this.expires;
    }

    public void setExpires(MonotonicTime expires) {
        this.expires = expires;
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    private static SignedExchangeSignature fromJson(JsonInput input) {
        String label = null;
        String signature = null;
        String integrity = null;
        String certUrl = null;
        String certSha256 = null;
        String validityUrl = null;
        MonotonicTime date = null;
        MonotonicTime expires = null;
        ArrayList<String> certificates = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "label": {
                    label = input.nextString();
                    continue block22;
                }
                case "signature": {
                    signature = input.nextString();
                    continue block22;
                }
                case "integrity": {
                    integrity = input.nextString();
                    continue block22;
                }
                case "certUrl": {
                    certUrl = input.nextString();
                    continue block22;
                }
                case "certSha256": {
                    certSha256 = input.nextString();
                    continue block22;
                }
                case "validityUrl": {
                    validityUrl = input.nextString();
                    continue block22;
                }
                case "date": {
                    date = MonotonicTime.parse(input.nextNumber());
                    continue block22;
                }
                case "expires": {
                    expires = MonotonicTime.parse(input.nextNumber());
                    continue block22;
                }
                case "certificates": {
                    input.beginArray();
                    certificates = new ArrayList<String>();
                    while (input.hasNext()) {
                        certificates.add(input.nextString());
                    }
                    input.endArray();
                    continue block22;
                }
            }
            input.skipValue();
        }
        return new SignedExchangeSignature(label, signature, integrity, certUrl, certSha256, validityUrl, date, expires, certificates);
    }
}

