/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.SignedExchangeSignature;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class SignedExchangeHeader {
    private String requestUrl;
    private String requestMethod;
    private Integer responseCode;
    private Map<String, Object> responseHeaders;
    private List<SignedExchangeSignature> signatures;

    private SignedExchangeHeader(String requestUrl, String requestMethod, Integer responseCode, Map<String, Object> responseHeaders, List<SignedExchangeSignature> signatures) {
        this.requestUrl = Objects.requireNonNull(requestUrl, "'requestUrl' is required for SignedExchangeHeader");
        this.requestMethod = Objects.requireNonNull(requestMethod, "'requestMethod' is required for SignedExchangeHeader");
        this.responseCode = Objects.requireNonNull(responseCode, "'responseCode' is required for SignedExchangeHeader");
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "'responseHeaders' is required for SignedExchangeHeader");
        this.signatures = Objects.requireNonNull(signatures, "'signatures' is required for SignedExchangeHeader");
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public Map<String, Object> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public List<SignedExchangeSignature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<SignedExchangeSignature> signatures) {
        this.signatures = signatures;
    }

    private static SignedExchangeHeader fromJson(JsonInput input) {
        String requestUrl = null;
        String requestMethod = null;
        Number responseCode = null;
        Map responseHeaders = null;
        List signatures = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestUrl": {
                    requestUrl = input.nextString();
                    continue block14;
                }
                case "requestMethod": {
                    requestMethod = input.nextString();
                    continue block14;
                }
                case "responseCode": {
                    responseCode = input.nextNumber();
                    continue block14;
                }
                case "responseHeaders": {
                    responseHeaders = (Map)input.read(Json.MAP_TYPE);
                    continue block14;
                }
                case "signatures": {
                    signatures = (List)input.read(new TypeToken<List<SignedExchangeSignature>>(){}.getType());
                    continue block14;
                }
            }
            input.skipValue();
        }
        return new SignedExchangeHeader(requestUrl, requestMethod, Integer.valueOf(String.valueOf(responseCode)), responseHeaders, signatures);
    }
}

