/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class ResponseBody {
    private final String body;
    private final Boolean base64Encoded;

    private ResponseBody(String body, Boolean base64Encoded) {
        this.body = Objects.requireNonNull(body, "'body' is required for ResponseBody");
        this.base64Encoded = Objects.requireNonNull(base64Encoded, "'base64Encoded' is required for ResponseBody");
    }

    private static ResponseBody fromJson(JsonInput input) {
        String body = input.nextString();
        Boolean base64Encoded = null;
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "base64Encoded": {
                    base64Encoded = input.nextBoolean();
                    continue block6;
                }
            }
            input.skipValue();
        }
        return new ResponseBody(body, base64Encoded);
    }

    public String getBody() {
        return this.body;
    }

    public Boolean getBase64Encoded() {
        return this.base64Encoded;
    }

    public String toString() {
        return "ResponseBody{body='" + this.body + '\'' + ", base64Encoded=" + this.base64Encoded + '}';
    }
}

