/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class LoadingFinished {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final Number encodedDataLength;
    private final Boolean shouldReportCorbBlocking;

    private LoadingFinished(RequestId requestId, MonotonicTime timestamp, Number encodedDataLength, Boolean shouldReportCorbBlocking) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for LoadingFinished");
        this.timestamp = Objects.requireNonNull(timestamp, "'timestamp' is required for LoadingFinished");
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "'encodedDataLength' is required for LoadingFinished");
        this.shouldReportCorbBlocking = shouldReportCorbBlocking;
    }

    private static LoadingFinished fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        MonotonicTime timestamp = null;
        Number encodedDataLength = null;
        Boolean shouldReportCorbBlocking = null;
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block10;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block10;
                }
                case "shouldReportCorbBlocking": {
                    shouldReportCorbBlocking = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        return new LoadingFinished(requestId, timestamp, encodedDataLength, shouldReportCorbBlocking);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    public Boolean getShouldReportCorbBlocking() {
        return this.shouldReportCorbBlocking;
    }

    public String toString() {
        return "LoadingFinished{requestId=" + this.requestId + ", timestamp=" + this.timestamp.getTimeStamp().toString() + ", encodedDataLength=" + this.encodedDataLength + ", shouldReportCorbBlocking=" + this.shouldReportCorbBlocking + '}';
    }
}

