/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Date;
import java.util.Objects;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.json.JsonInput;

public class Cookie {
    private String name;
    private String value;
    private String domain;
    private String path;
    private long expires;
    private boolean httpOnly;
    private boolean secure;

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public long getExpires() {
        return this.expires;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie(String name, String value, String domain, String path, long expires, Boolean httpOnly, Boolean secure) {
        this.name = Objects.requireNonNull(name, "'name' is required for Cookie");
        this.value = Objects.requireNonNull(value, "'value' is required for Cookie");
        this.domain = Objects.requireNonNull(domain, "'domain' is required for Cookie");
        this.path = Objects.requireNonNull(path, "'path' is required for Cookie");
        this.expires = expires;
        this.httpOnly = httpOnly;
        this.secure = secure;
    }

    org.openqa.selenium.Cookie asSeleniumCookie() {
        return new Cookie.Builder(this.name, this.value).domain(this.domain).path(this.path).expiresOn(new Date(this.expires)).isSecure(this.secure).isHttpOnly(this.httpOnly).build();
    }

    public static Cookie fromSeleniumCookie(org.openqa.selenium.Cookie cookie) {
        return new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getExpiry() != null ? cookie.getExpiry().getTime() : 0L, cookie.isHttpOnly(), cookie.isSecure());
    }

    private static Cookie fromJson(JsonInput input) {
        String name = null;
        String value = null;
        String domain = null;
        String path = null;
        long expires = 0L;
        boolean httpOnly = false;
        boolean secure = false;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block18;
                }
                case "value": {
                    value = input.nextString();
                    continue block18;
                }
                case "domain": {
                    domain = input.nextString();
                    continue block18;
                }
                case "path": {
                    path = input.nextString();
                    continue block18;
                }
                case "expires": {
                    expires = input.nextNumber().longValue();
                    continue block18;
                }
                case "httpOnly": {
                    httpOnly = input.nextBoolean();
                    continue block18;
                }
                case "secure": {
                    secure = input.nextBoolean();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Cookie(name, value, domain, path, expires, httpOnly, secure);
    }
}

