/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.Source;
import org.openqa.selenium.json.JsonInput;

public class AuthChallenge {
    private String origin;
    private String realm;
    private String scheme;
    private Source source;

    private AuthChallenge(String origin, String realm, String scheme, Source source) {
        this.origin = Objects.requireNonNull(origin, "'origin' is mandatory for AuthChallenge");
        this.realm = Objects.requireNonNull(realm, "'realm' is mandatory for AuthChallenge");
        this.scheme = Objects.requireNonNull(scheme, "'scheme' is mandatory for AuthChallenge");
        this.source = source;
    }

    private static AuthChallenge fromJson(JsonInput input) {
        String origin = null;
        String realm = null;
        String scheme = null;
        Source source = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "origin": {
                    origin = input.nextString();
                    continue block12;
                }
                case "realm": {
                    realm = input.nextString();
                    continue block12;
                }
                case "scheme": {
                    scheme = input.nextString();
                    continue block12;
                }
                case "source": {
                    source = Source.getSource(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AuthChallenge(origin, realm, scheme, source);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getRealm() {
        return this.realm;
    }

    public Source getSource() {
        return this.source;
    }
}

