/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

class HttpMessage {
    private final Multimap<String, String> headers = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newLinkedList);
    private final Map<String, Object> attributes = Maps.newHashMap();
    private byte[] content = new byte[0];

    HttpMessage() {
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Iterable<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Iterable<String> getHeaders(String name) {
        return this.headers.get((Object)name);
    }

    public String getHeader(String name) {
        Collection values = this.headers.get((Object)name);
        return values.isEmpty() ? null : (String)values.iterator().next();
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.headers.put((Object)name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
    }

    public void removeHeader(String name) {
        this.headers.removeAll((Object)name);
    }

    public void setContent(byte[] data) {
        this.content = data;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentString() {
        Charset charset = Charsets.UTF_8;
        try {
            String contentType = this.getHeader("Content-Type");
            if (contentType != null) {
                MediaType mediaType = MediaType.parse((String)contentType);
                charset = (Charset)mediaType.charset().or((Object)Charsets.UTF_8);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new String(this.content, charset);
    }
}

