/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class OkHttpClient
implements HttpClient {
    private final okhttp3.OkHttpClient client;
    private final URL baseUrl;

    public OkHttpClient(okhttp3.OkHttpClient client, URL url) {
        this.client = client;
        this.baseUrl = url;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        HttpUrl.Builder url;
        Request.Builder builder = new Request.Builder();
        try {
            String rawUrl = request.getUri().startsWith("http:") || request.getUri().startsWith("https:") ? request.getUri() : this.baseUrl.toExternalForm().replaceAll("/$", "") + request.getUri();
            url = HttpUrl.parse((String)rawUrl).newBuilder();
        }
        catch (NullPointerException e) {
            throw new IOException("Unable to parse URL: " + this.baseUrl.toString() + request.getUri());
        }
        for (String name2 : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name2)) {
                url.addQueryParameter(name2, value);
            }
        }
        builder.url(url.build());
        for (String name2 : request.getHeaderNames()) {
            for (String value : request.getHeaders(name2)) {
                builder.addHeader(name2, value);
            }
        }
        if (request.getHeader("User-Agent") == null) {
            builder.addHeader("User-Agent", USER_AGENT);
        }
        switch (request.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                String rawType = Optional.ofNullable(request.getHeader("Content-Type")).orElse("application/json; charset=utf-8");
                MediaType type = MediaType.parse((String)rawType);
                RequestBody body = RequestBody.create((MediaType)type, (byte[])request.getContent());
                builder.post(body);
                break;
            }
            case DELETE: {
                builder.delete();
            }
        }
        Response response = this.client.newCall(builder.build()).execute();
        HttpResponse toReturn = new HttpResponse();
        toReturn.setContent(response.body().bytes());
        toReturn.setStatus(response.code());
        response.headers().names().forEach(name -> response.headers(name).forEach(value -> toReturn.addHeader((String)name, (String)value)));
        return toReturn;
    }

    @Override
    public void close() {
    }

    public static class Factory
    implements HttpClient.Factory {
        private final ConnectionPool pool = new ConnectionPool();
        private final long connectionTimeout;
        private final long readTimeout;

        public Factory() {
            this(Duration.ofMinutes(2L), Duration.ofHours(3L));
        }

        public Factory(Duration connectionTimeout, Duration readTimeout) {
            Objects.requireNonNull(connectionTimeout, "Connection timeout cannot be null");
            Objects.requireNonNull(readTimeout, "Read timeout cannot be null");
            this.connectionTimeout = connectionTimeout.toMillis();
            this.readTimeout = readTimeout.toMillis();
        }

        @Override
        public HttpClient createClient(URL url) {
            OkHttpClient.Builder client = new OkHttpClient.Builder().connectionPool(this.pool).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(false).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).connectTimeout(this.connectionTimeout, TimeUnit.MILLISECONDS);
            String info = url.getUserInfo();
            if (!Strings.isNullOrEmpty((String)info)) {
                String[] parts = info.split(":", 2);
                String user = parts[0];
                String pass = parts.length > 1 ? parts[1] : null;
                String credentials = Credentials.basic((String)user, (String)pass);
                client.authenticator((route, response) -> {
                    if (response.request().header("Authorization") != null) {
                        return null;
                    }
                    return response.request().newBuilder().header("Authorization", credentials).build();
                });
            }
            return new OkHttpClient(client.build(), url);
        }

        @Override
        public void cleanupIdleClients() {
            this.pool.evictAll();
        }
    }
}

