/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Beta;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LogLevelMapping;

@Beta
public class SessionLogs {
    private final Map<String, LogEntries> logTypeToEntriesMap = new HashMap<String, LogEntries>();

    public LogEntries getLogs(String logType) {
        if (logType == null || !this.logTypeToEntriesMap.containsKey(logType)) {
            return new LogEntries(Collections.emptyList());
        }
        return this.logTypeToEntriesMap.get(logType);
    }

    public void addLog(String logType, LogEntries logEntries) {
        this.logTypeToEntriesMap.put(logType, logEntries);
    }

    public Set<String> getLogTypes() {
        return this.logTypeToEntriesMap.keySet();
    }

    public Map<String, LogEntries> getAll() {
        return Collections.unmodifiableMap(this.logTypeToEntriesMap);
    }

    public static SessionLogs fromJSON(JsonObject rawSessionLogs) {
        SessionLogs sessionLogs = new SessionLogs();
        for (Map.Entry entry : rawSessionLogs.entrySet()) {
            String logType = (String)entry.getKey();
            JsonArray rawLogEntries = ((JsonElement)entry.getValue()).getAsJsonArray();
            ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
            for (int index = 0; index < rawLogEntries.size(); ++index) {
                JsonObject rawEntry = rawLogEntries.get(index).getAsJsonObject();
                logEntries.add(new LogEntry(LogLevelMapping.toLevel(rawEntry.get("level").getAsString()), rawEntry.get("timestamp").getAsLong(), rawEntry.get("message").getAsString()));
            }
            sessionLogs.addLog(logType, new LogEntries(logEntries));
        }
        return sessionLogs;
    }
}

