/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteKeyboard;
import org.openqa.selenium.remote.RemoteLogs;
import org.openqa.selenium.remote.RemoteMouse;
import org.openqa.selenium.remote.RemoteStatus;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.UselessFileDetector;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;
import org.openqa.selenium.security.Credentials;

@Augmentable
public class RemoteWebDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities,
TakesScreenshot {
    private static final Logger logger = Logger.getLogger(RemoteWebDriver.class.getName());
    private Level level = Level.FINE;
    private ErrorHandler errorHandler = new ErrorHandler();
    private CommandExecutor executor;
    private Capabilities capabilities;
    private SessionId sessionId;
    private FileDetector fileDetector = new UselessFileDetector();
    private ExecuteMethod executeMethod;
    private JsonToWebElementConverter converter;
    private RemoteKeyboard keyboard;
    private RemoteMouse mouse;
    private Logs remoteLogs;
    private LocalLogs localLogs;

    protected RemoteWebDriver() {
        this.init((Capabilities)new DesiredCapabilities(), null);
    }

    public RemoteWebDriver(CommandExecutor executor, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this.executor = executor;
        this.init(desiredCapabilities, requiredCapabilities);
        if (executor instanceof NeedsLocalLogs) {
            ((NeedsLocalLogs)executor).setLocalLogs(this.localLogs);
        }
        try {
            this.startClient();
        }
        catch (RuntimeException e) {
            try {
                this.stopClient();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw e;
        }
        try {
            this.startSession(desiredCapabilities, requiredCapabilities);
        }
        catch (RuntimeException e) {
            try {
                this.quit();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw e;
        }
    }

    public RemoteWebDriver(CommandExecutor executor, Capabilities desiredCapabilities) {
        this(executor, desiredCapabilities, null);
    }

    public RemoteWebDriver(Capabilities desiredCapabilities) {
        this((URL)null, desiredCapabilities);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(new HttpCommandExecutor(remoteAddress), desiredCapabilities, requiredCapabilities);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        this(new HttpCommandExecutor(remoteAddress), desiredCapabilities, null);
    }

    private void init(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        boolean isProfilingEnabled;
        logger.addHandler((Handler)LoggingHandler.getInstance());
        this.converter = new JsonToWebElementConverter(this);
        this.executeMethod = new RemoteExecuteMethod(this);
        this.keyboard = new RemoteKeyboard(this.executeMethod);
        this.mouse = new RemoteMouse(this.executeMethod);
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        boolean bl = isProfilingEnabled = desiredCapabilities != null && desiredCapabilities.is("webdriver.logging.profiler.enabled");
        if (requiredCapabilities != null && requiredCapabilities.getCapability("webdriver.logging.profiler.enabled") != null) {
            isProfilingEnabled = requiredCapabilities.is("webdriver.logging.profiler.enabled");
        }
        if (isProfilingEnabled) {
            builder.add((Object)"profiler");
        }
        LoggingPreferences mergedLoggingPrefs = new LoggingPreferences();
        if (desiredCapabilities != null) {
            mergedLoggingPrefs.addPreferences((LoggingPreferences)desiredCapabilities.getCapability("loggingPrefs"));
        }
        if (requiredCapabilities != null) {
            mergedLoggingPrefs.addPreferences((LoggingPreferences)requiredCapabilities.getCapability("loggingPrefs"));
        }
        if (mergedLoggingPrefs.getEnabledLogTypes().contains("client") && mergedLoggingPrefs.getLevel("client") != Level.OFF || !mergedLoggingPrefs.getEnabledLogTypes().contains("client")) {
            builder.add((Object)"client");
        }
        ImmutableSet logTypesToInclude = builder.build();
        LocalLogs performanceLogger = LocalLogs.getStoringLoggerInstance((Set)logTypesToInclude);
        LocalLogs clientLogs = LocalLogs.getHandlerBasedLoggerInstance((LoggingHandler)LoggingHandler.getInstance(), (Set)logTypesToInclude);
        this.localLogs = LocalLogs.getCombinedLogsHolder((LocalLogs)clientLogs, (LocalLogs)performanceLogger);
        this.remoteLogs = new RemoteLogs(this.executeMethod, this.localLogs);
    }

    public void setFileDetector(FileDetector detector) {
        if (detector == null) {
            throw new WebDriverException("You may not set a file detector that is null");
        }
        this.fileDetector = detector;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    protected void setSessionId(String opaqueKey) {
        this.sessionId = new SessionId(opaqueKey);
    }

    protected void startSession(Capabilities desiredCapabilities) {
        this.startSession(desiredCapabilities, null);
    }

    protected void startSession(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        Platform platform;
        ImmutableMap.Builder paramBuilder = new ImmutableMap.Builder();
        paramBuilder.put((Object)"desiredCapabilities", (Object)desiredCapabilities);
        if (requiredCapabilities != null) {
            paramBuilder.put((Object)"requiredCapabilities", (Object)requiredCapabilities);
        }
        ImmutableMap parameters = paramBuilder.build();
        Response response = this.execute("newSession", (Map<String, ?>)parameters);
        Map rawCapabilities = (Map)response.getValue();
        DesiredCapabilities returnedCapabilities = new DesiredCapabilities();
        for (Map.Entry entry : rawCapabilities.entrySet()) {
            if ("platform".equals(entry.getKey())) continue;
            returnedCapabilities.setCapability((String)entry.getKey(), entry.getValue());
        }
        String platformString = (String)rawCapabilities.get("platform");
        try {
            platform = platformString == null || "".equals(platformString) ? Platform.ANY : Platform.valueOf((String)platformString);
        }
        catch (IllegalArgumentException e) {
            platform = Platform.extractFromSysProperty((String)platformString);
        }
        returnedCapabilities.setPlatform(platform);
        this.capabilities = returnedCapabilities;
        this.sessionId = new SessionId(response.getSessionId());
    }

    protected void startClient() {
    }

    protected void stopClient() {
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public CommandExecutor getCommandExecutor() {
        return this.executor;
    }

    protected void setCommandExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void get(String url) {
        this.execute("get", (Map<String, ?>)ImmutableMap.of((Object)"url", (Object)url));
    }

    @Deprecated
    public RemoteStatus getRemoteStatus() {
        Response response = this.execute("status");
        return new RemoteStatus((Map)response.getValue());
    }

    public String getTitle() {
        Response response = this.execute("getTitle");
        Object value = response.getValue();
        return value == null ? "" : value.toString();
    }

    public String getCurrentUrl() {
        return this.execute("getCurrentUrl").getValue().toString();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute("screenshot");
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return (X)outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            String base64EncodedPng = new String((byte[])result);
            return (X)outputType.convertFromBase64Png(base64EncodedPng);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", "screenshot", result == null ? "null" : result.getClass().getName() + " instance"));
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String by, String using) {
        WebElement element;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        Response response = this.execute("findElement", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        Object value = response.getValue();
        try {
            element = (WebElement)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to WebElement: " + value, (Throwable)ex);
        }
        this.setFoundBy((SearchContext)this, element, by, using);
        return element;
    }

    protected void setFoundBy(SearchContext context, WebElement element, String by, String using) {
        if (element instanceof RemoteWebElement) {
            ((RemoteWebElement)element).setFoundBy(context, by, using);
        }
    }

    protected List<WebElement> findElements(String by, String using) {
        List allElements;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        Response response = this.execute("findElements", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        Object value = response.getValue();
        try {
            allElements = (List)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<WebElement>: " + value, (Throwable)ex);
        }
        for (WebElement element : allElements) {
            this.setFoundBy((SearchContext)this, element, by, using);
        }
        return allElements;
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public String getPageSource() {
        return (String)this.execute("getPageSource").getValue();
    }

    public void close() {
        this.execute("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        try {
            this.execute("quit");
        }
        finally {
            this.sessionId = null;
            this.stopClient();
        }
    }

    public Set<String> getWindowHandles() {
        Response response = this.execute("getWindowHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getWindowHandle() {
        return String.valueOf(this.execute("getCurrentWindowHandle").getValue());
    }

    public Object executeScript(String script, Object ... args) {
        if (!this.capabilities.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        return this.execute("executeScript", (Map<String, ?>)params).getValue();
    }

    public Object executeAsyncScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        return this.execute("executeAsyncScript", (Map<String, ?>)params).getValue();
    }

    private boolean isJavascriptEnabled() {
        return this.capabilities.isJavascriptEnabled();
    }

    public WebDriver.TargetLocator switchTo() {
        return new RemoteTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new RemoteNavigation();
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriverOptions();
    }

    protected void setElementConverter(JsonToWebElementConverter converter) {
        this.converter = converter;
    }

    protected JsonToWebElementConverter getElementConverter() {
        return this.converter;
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        Response response;
        Command command = new Command(this.sessionId, driverCommand, parameters);
        long start = System.currentTimeMillis();
        String currentName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format("Forwarding %s on session %s to remote", driverCommand, this.sessionId));
        try {
            this.log(this.sessionId, command.getName(), command, When.BEFORE);
            response = this.executor.execute(command);
            this.log(this.sessionId, command.getName(), command, When.AFTER);
            if (response == null) {
                Response response2 = null;
                return response2;
            }
            Object value = this.converter.apply(response.getValue());
            response.setValue(value);
        }
        catch (SessionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            this.log(this.sessionId, command.getName(), command, When.EXCEPTION);
            String errorMessage = "Error communicating with the remote browser. It may have died.";
            if (driverCommand.equals("newSession")) {
                errorMessage = "Could not start a new session. Possible causes are invalid address of the remote server or browser start-up failure.";
            }
            throw new UnreachableBrowserException(errorMessage, e);
        }
        finally {
            Thread.currentThread().setName(currentName);
        }
        try {
            this.errorHandler.throwIfResponseFailed(response, System.currentTimeMillis() - start);
        }
        catch (WebDriverException ex) {
            if (parameters != null && parameters.containsKey("using") && parameters.containsKey("value")) {
                ex.addInfo("*** Element info", String.format("{Using=%s, value=%s}", parameters.get("using"), parameters.get("value")));
            }
            ex.addInfo("Driver info", this.getClass().getName());
            if (this.getSessionId() != null) {
                ex.addInfo("Session ID", this.getSessionId().toString());
            }
            if (this.getCapabilities() != null) {
                ex.addInfo("Capabilities", this.getCapabilities().toString());
            }
            Throwables.propagate((Throwable)ex);
        }
        return response;
    }

    protected Response execute(String command) {
        return this.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    protected ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    protected void log(SessionId sessionId, String commandName, Object toLog, When when) {
        String text = "" + toLog;
        if ((commandName.equals("executeScript") || commandName.equals("executeAsyncScript")) && text.length() > 100 && Boolean.getBoolean("webdriver.remote.shorten_log_messages")) {
            text = text.substring(0, 100) + "...";
        }
        switch (when) {
            case BEFORE: {
                logger.log(this.level, "Executing: " + commandName + " " + text);
                break;
            }
            case AFTER: {
                logger.log(this.level, "Executed: " + text);
                break;
            }
            case EXCEPTION: {
                logger.log(this.level, "Exception: " + text);
                break;
            }
            default: {
                logger.log(this.level, text);
            }
        }
    }

    public FileDetector getFileDetector() {
        return this.fileDetector;
    }

    public String toString() {
        Capabilities caps = this.getCapabilities();
        if (caps == null) {
            return super.toString();
        }
        return String.format("%s: %s on %s (%s)", this.getClass().getSimpleName(), caps.getBrowserName(), caps.getPlatform(), this.getSessionId());
    }

    public static enum When {
        BEFORE,
        AFTER,
        EXCEPTION;

    }

    private class RemoteAlert
    implements Alert {
        public void dismiss() {
            RemoteWebDriver.this.execute("dismissAlert");
        }

        public void accept() {
            RemoteWebDriver.this.execute("acceptAlert");
        }

        public String getText() {
            return (String)RemoteWebDriver.this.execute("getAlertText").getValue();
        }

        public void sendKeys(String keysToSend) {
            RemoteWebDriver.this.execute("setAlertValue", (Map<String, ?>)ImmutableMap.of((Object)"text", (Object)keysToSend));
        }

        public void authenticateUsing(Credentials credentials) {
            throw new UnsupportedCommandException("Not implemented yet");
        }
    }

    protected class RemoteTargetLocator
    implements WebDriver.TargetLocator {
        protected RemoteTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            RemoteWebDriver.this.execute("switchToFrame", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)frameIndex));
            return RemoteWebDriver.this;
        }

        public WebDriver frame(String frameName) {
            String name = frameName.replaceAll("(['\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-/\\[\\]\\(\\)])", "\\\\$1");
            List<WebElement> frameElements = RemoteWebDriver.this.findElements(By.cssSelector((String)("frame[name='" + name + "'],iframe[name='" + name + "']")));
            if (frameElements.size() == 0) {
                frameElements = RemoteWebDriver.this.findElements(By.cssSelector((String)("frame#" + name + ",iframe#" + name)));
            }
            if (frameElements.size() == 0) {
                throw new NoSuchFrameException("No frame element found by name or id " + frameName);
            }
            return this.frame(frameElements.get(0));
        }

        public WebDriver frame(WebElement frameElement) {
            Object elementAsJson = new WebElementToJsonConverter().apply(frameElement);
            RemoteWebDriver.this.execute("switchToFrame", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)elementAsJson));
            return RemoteWebDriver.this;
        }

        public WebDriver parentFrame() {
            RemoteWebDriver.this.execute("switchToParentFrame");
            return RemoteWebDriver.this;
        }

        public WebDriver window(String windowName) {
            RemoteWebDriver.this.execute("switchToWindow", (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)windowName));
            return RemoteWebDriver.this;
        }

        public WebDriver defaultContent() {
            HashMap frameId = Maps.newHashMap();
            frameId.put("id", null);
            RemoteWebDriver.this.execute("switchToFrame", frameId);
            return RemoteWebDriver.this;
        }

        public WebElement activeElement() {
            Response response = RemoteWebDriver.this.execute("getActiveElement");
            return (WebElement)response.getValue();
        }

        public Alert alert() {
            RemoteWebDriver.this.execute("getAlertText");
            return new RemoteAlert();
        }
    }

    private class RemoteNavigation
    implements WebDriver.Navigation {
        private RemoteNavigation() {
        }

        public void back() {
            RemoteWebDriver.this.execute("goBack");
        }

        public void forward() {
            RemoteWebDriver.this.execute("goForward");
        }

        public void to(String url) {
            RemoteWebDriver.this.get(url);
        }

        public void to(URL url) {
            RemoteWebDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            RemoteWebDriver.this.execute("refresh");
        }
    }

    protected class RemoteWebDriverOptions
    implements WebDriver.Options {
        protected RemoteWebDriverOptions() {
        }

        @Beta
        public Logs logs() {
            return RemoteWebDriver.this.remoteLogs;
        }

        public void addCookie(Cookie cookie) {
            cookie.validate();
            RemoteWebDriver.this.execute("addCookie", (Map<String, ?>)ImmutableMap.of((Object)"cookie", (Object)cookie));
        }

        public void deleteCookieNamed(String name) {
            RemoteWebDriver.this.execute("deleteCookie", (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            RemoteWebDriver.this.execute("deleteAllCookies");
        }

        public Set<Cookie> getCookies() {
            Object returned = RemoteWebDriver.this.execute("getCookies").getValue();
            List cookies = new JsonToBeanConverter().convert(List.class, returned);
            HashSet<Cookie> toReturn = new HashSet<Cookie>();
            for (Map rawCookie : cookies) {
                String name = (String)rawCookie.get("name");
                String value = (String)rawCookie.get("value");
                String path = (String)rawCookie.get("path");
                String domain = (String)rawCookie.get("domain");
                boolean secure = rawCookie.containsKey("secure") && (Boolean)rawCookie.get("secure") != false;
                Number expiryNum = (Number)rawCookie.get("expiry");
                Date expiry = expiryNum == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue()));
                toReturn.add(new Cookie.Builder(name, value).path(path).domain(domain).isSecure(secure).expiresOn(expiry).build());
            }
            return toReturn;
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public WebDriver.Timeouts timeouts() {
            return new RemoteTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            return new RemoteInputMethodManager();
        }

        @Beta
        public WebDriver.Window window() {
            return new RemoteWindow();
        }

        @Beta
        protected class RemoteWindow
        implements WebDriver.Window {
            protected RemoteWindow() {
            }

            public void setSize(Dimension targetSize) {
                RemoteWebDriver.this.execute("setWindowSize", (Map<String, ?>)ImmutableMap.of((Object)"windowHandle", (Object)"current", (Object)"width", (Object)targetSize.width, (Object)"height", (Object)targetSize.height));
            }

            public void setPosition(Point targetPosition) {
                RemoteWebDriver.this.execute("setWindowPosition", (Map<String, ?>)ImmutableMap.of((Object)"windowHandle", (Object)"current", (Object)"x", (Object)targetPosition.x, (Object)"y", (Object)targetPosition.y));
            }

            public Dimension getSize() {
                Response response = RemoteWebDriver.this.execute("getWindowSize", (Map<String, ?>)ImmutableMap.of((Object)"windowHandle", (Object)"current"));
                Map rawSize = (Map)response.getValue();
                int width = ((Number)rawSize.get("width")).intValue();
                int height = ((Number)rawSize.get("height")).intValue();
                return new Dimension(width, height);
            }

            public Point getPosition() {
                Response response = RemoteWebDriver.this.execute("getWindowPosition", (Map<String, ?>)ImmutableMap.of((Object)"windowHandle", (Object)"current"));
                Map rawPoint = (Map)response.getValue();
                int x = ((Number)rawPoint.get("x")).intValue();
                int y = ((Number)rawPoint.get("y")).intValue();
                return new Point(x, y);
            }

            public void maximize() {
                RemoteWebDriver.this.execute("maximizeWindow", (Map<String, ?>)ImmutableMap.of((Object)"windowHandle", (Object)"current"));
            }
        }

        protected class RemoteTimeouts
        implements WebDriver.Timeouts {
            protected RemoteTimeouts() {
            }

            public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute("implicitlyWait", (Map<String, ?>)ImmutableMap.of((Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit)));
                return this;
            }

            public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute("setScriptTimeout", (Map<String, ?>)ImmutableMap.of((Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                return this;
            }

            public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
                RemoteWebDriver.this.execute("setTimeout", (Map<String, ?>)ImmutableMap.of((Object)"type", (Object)"page load", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                return this;
            }
        }

        protected class RemoteInputMethodManager
        implements WebDriver.ImeHandler {
            protected RemoteInputMethodManager() {
            }

            public List<String> getAvailableEngines() {
                Response response = RemoteWebDriver.this.execute("imeGetAvailableEngines");
                return (List)response.getValue();
            }

            public String getActiveEngine() {
                Response response = RemoteWebDriver.this.execute("imeGetActiveEngine");
                return (String)response.getValue();
            }

            public boolean isActivated() {
                Response response = RemoteWebDriver.this.execute("imeIsActivated");
                return (Boolean)response.getValue();
            }

            public void deactivate() {
                RemoteWebDriver.this.execute("imeDeactivate");
            }

            public void activateEngine(String engine) {
                RemoteWebDriver.this.execute("imeActivateEngine", (Map<String, ?>)ImmutableMap.of((Object)"engine", (Object)engine));
            }
        }
    }
}

