/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;

public class DriverService {
    private final URL url;
    private final ReentrantLock lock = new ReentrantLock();
    private CommandLine process = null;
    private final String executable;
    private final ImmutableList<String> args;
    private final ImmutableMap<String, String> environment;

    protected DriverService(File executable, int port, ImmutableMap<String, String> environment, File logFile) throws IOException {
        this.executable = executable.getCanonicalPath();
        this.args = this.buildArgsFrom(port, logFile);
        this.url = new URL(String.format("http://localhost:%d", port));
        this.environment = environment;
    }

    private ImmutableList<String> buildArgsFrom(int port, File logFile) {
        ImmutableList.Builder argsBuilder = ImmutableList.builder();
        argsBuilder.add((Object)String.format("--port=%d", port));
        if (logFile != null) {
            argsBuilder.add((Object)String.format("--log-path=%s", logFile.getAbsolutePath()));
        }
        return argsBuilder.build();
    }

    public URL getUrl() {
        return this.url;
    }

    protected static File findExecutable(String exeName, String exeProperty, String exeDocs, String exeDownload) {
        String defaultPath = CommandLine.find(exeName);
        String exePath = System.getProperty(exeProperty, defaultPath);
        Preconditions.checkState((exePath != null ? 1 : 0) != 0, (String)"The path to the driver executable must be set by the %s system property; for more information, see %s. The latest version can be downloaded from %s", (Object[])new Object[]{exeProperty, exeDocs, exeDownload});
        File exe = new File(exePath);
        DriverService.checkExecutable(exe);
        return exe;
    }

    private static void checkExecutable(File exe) {
        Preconditions.checkState((boolean)exe.exists(), (String)"The driver executable does not exist: %s", (Object[])new Object[]{exe.getAbsolutePath()});
        Preconditions.checkState((!exe.isDirectory() ? 1 : 0) != 0, (String)"The driver executable is a directory: %s", (Object[])new Object[]{exe.getAbsolutePath()});
        Preconditions.checkState((boolean)FileHandler.canExecute(exe), (String)"The driver is not executable: %s", (Object[])new Object[]{exe.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null) {
                boolean bl = false;
                return bl;
            }
            this.process.destroy();
            boolean bl = false;
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            this.process = new CommandLine(this.executable, (String[])this.args.toArray((Object[])new String[0]));
            this.process.setEnvironmentVariables((Map<String, String>)this.environment);
            this.process.copyOutputTo(System.err);
            this.process.executeAsync();
            URL status = new URL(this.url.toString() + "/status");
            new UrlChecker().waitUntilAvailable(20L, TimeUnit.SECONDS, status);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for driver server to start.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return;
            }
            URL killUrl = new URL(this.url.toString() + "/shutdown");
            new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
            this.process.destroy();
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for driver server to shutdown.", (Throwable)e);
        }
        finally {
            this.process = null;
            this.lock.unlock();
        }
    }

    public static abstract class Builder {
        protected int port = 0;
        protected File exe = null;
        protected ImmutableMap<String, String> environment = ImmutableMap.of();
        protected File logFile;

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            DriverService.checkExecutable(file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public DriverService build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            Preconditions.checkState((this.exe != null ? 1 : 0) != 0, (Object)"Path to the driver executable not specified");
            try {
                return this.buildDriverService();
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        protected abstract DriverService buildDriverService() throws IOException;
    }
}

