/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import org.openqa.selenium.browserlaunchers.locators.SingleBrowserLocator;
import org.openqa.selenium.os.WindowsUtils;

public class SafariLocator
extends SingleBrowserLocator {
    private static final String[] USUAL_UNIX_LAUNCHER_LOCATIONS = new String[]{"/Applications/Safari.app/Contents/MacOS"};
    private static final String[] USUAL_WINDOWS_LAUNCHER_LOCATIONS = new String[]{WindowsUtils.getProgramFilesPath() + "\\Safari"};

    @Override
    protected String browserName() {
        return "Safari";
    }

    @Override
    protected String seleniumBrowserName() {
        return "safari";
    }

    @Override
    protected String[] standardlauncherFilenames() {
        if (WindowsUtils.thisIsWindows()) {
            return new String[]{"Safari.exe"};
        }
        return new String[]{"Safari"};
    }

    @Override
    protected String browserPathOverridePropertyName() {
        return "SafariDefaultPath";
    }

    @Override
    protected String[] usualLauncherLocations() {
        return WindowsUtils.thisIsWindows() ? USUAL_WINDOWS_LAUNCHER_LOCATIONS : USUAL_UNIX_LAUNCHER_LOCATIONS;
    }
}

