/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ScreenshotException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandler {
    private static final String MESSAGE = "message";
    private static final String SCREEN_SHOT = "screen";
    private static final String CLASS = "class";
    private static final String STACK_TRACE = "stackTrace";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String METHOD_NAME = "methodName";
    private static final String CLASS_NAME = "className";
    private static final String FILE_NAME = "fileName";
    private static final String UNKNOWN_CLASS = "<anonymous class>";
    private static final String UNKNOWN_METHOD = "<anonymous method>";
    private static final String UNKNOWN_FILE = null;
    private final ErrorCodes errorCodes = new ErrorCodes();
    private boolean includeServerErrors;

    public ErrorHandler() {
        this(true);
    }

    public ErrorHandler(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
    }

    public boolean isIncludeServerErrors() {
        return this.includeServerErrors;
    }

    public void setIncludeServerErrors(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
    }

    public Response throwIfResponseFailed(Response response, long duration) throws RuntimeException {
        if (response.getStatus() == 0) {
            return response;
        }
        if (response.getValue() instanceof Throwable) {
            throw Throwables.propagate((Throwable)((Throwable)response.getValue()));
        }
        Class<? extends WebDriverException> outerErrorType = this.errorCodes.getExceptionType(response.getStatus());
        Object value = response.getValue();
        String message = null;
        Object cause = null;
        if (value instanceof Map) {
            Map rawErrorData = (Map)value;
            try {
                message = (String)rawErrorData.get(MESSAGE);
            }
            catch (ClassCastException e) {
                message = String.valueOf(e);
            }
            Throwable serverError = this.rebuildServerError(rawErrorData);
            if (serverError == null) {
                if (this.includeServerErrors) {
                    message = message + " (WARNING: The server did not provide any stacktrace information)";
                }
            } else if (!this.includeServerErrors) {
                message = message + " (WARNING: The client has suppressed server-side stacktraces)";
            } else {
                cause = serverError;
            }
            if (rawErrorData.get(SCREEN_SHOT) != null) {
                cause = new ScreenshotException(String.valueOf(rawErrorData.get(SCREEN_SHOT)), (Throwable)cause);
            }
        } else if (value != null) {
            message = String.valueOf(value);
        }
        String duration1 = this.duration(duration);
        if (message != null && message.indexOf(duration1) == -1) {
            message = message + duration1;
        }
        Throwable toThrow = null;
        if (outerErrorType.equals(UnhandledAlertException.class) && value instanceof Map) {
            toThrow = this.createUnhandledAlertException(value);
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class, Throwable.class}, new Object[]{message, cause});
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class}, new Object[]{message});
        }
        if (toThrow == null) {
            throw new WebDriverException(message, cause);
        }
        if (toThrow instanceof RuntimeException) {
            throw (RuntimeException)toThrow;
        }
        throw new WebDriverException(toThrow);
    }

    private Throwable createUnhandledAlertException(Object value) {
        Map rawErrorData = (Map)value;
        if (rawErrorData.containsKey("alert")) {
            Map alert = (Map)rawErrorData.get("alert");
            return this.createThrowable(UnhandledAlertException.class, new Class[]{String.class, String.class}, new Object[]{rawErrorData.get(MESSAGE), alert.get("text")});
        }
        return null;
    }

    private String duration(long duration) {
        String prefix = "\nCommand duration or timeout: ";
        if (duration < 1000L) {
            return prefix + duration + " milliseconds";
        }
        return prefix + new BigDecimal(duration).divide(new BigDecimal(1000)).setScale(2, RoundingMode.HALF_UP) + " seconds";
    }

    private <T extends Throwable> T createThrowable(Class<T> clazz, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            return (T)((Throwable)constructor.newInstance(parameters));
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (OutOfMemoryError error) {
            // empty catch block
        }
        return null;
    }

    private Throwable rebuildServerError(Map<String, Object> rawErrorData) {
        if (!rawErrorData.containsKey(CLASS) && !rawErrorData.containsKey(STACK_TRACE)) {
            return null;
        }
        Object toReturn = null;
        String message = (String)rawErrorData.get(MESSAGE);
        if (rawErrorData.containsKey(CLASS)) {
            String className = (String)rawErrorData.get(CLASS);
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.equals(UnhandledAlertException.class)) {
                    toReturn = this.createUnhandledAlertException(rawErrorData);
                } else if (Throwable.class.isAssignableFrom(clazz)) {
                    Class<?> throwableType = clazz;
                    toReturn = this.createThrowable(throwableType, new Class[]{String.class}, new Object[]{message});
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        if (toReturn == null) {
            toReturn = new UnknownServerException(message);
        }
        StackTraceElement[] stackTrace = new StackTraceElement[]{};
        if (rawErrorData.containsKey(STACK_TRACE)) {
            List stackTraceInfo = (List)rawErrorData.get(STACK_TRACE);
            Iterable stackFrames = Iterables.transform((Iterable)stackTraceInfo, (Function)new FrameInfoToStackFrame());
            stackFrames = Iterables.filter((Iterable)stackFrames, (Predicate)Predicates.notNull());
            stackTrace = (StackTraceElement[])Iterables.toArray((Iterable)stackFrames, StackTraceElement.class);
        }
        ((Throwable)toReturn).setStackTrace(stackTrace);
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrameInfoToStackFrame
    implements Function<Map<String, Object>, StackTraceElement> {
        private FrameInfoToStackFrame() {
        }

        public StackTraceElement apply(Map<String, Object> frameInfo) {
            if (frameInfo == null) {
                return null;
            }
            Number lineNumber = (Number)frameInfo.get(ErrorHandler.LINE_NUMBER);
            if (lineNumber == null) {
                return null;
            }
            String className = frameInfo.containsKey(ErrorHandler.CLASS_NAME) ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get(ErrorHandler.CLASS_NAME)) : ErrorHandler.UNKNOWN_CLASS;
            String methodName = frameInfo.containsKey(ErrorHandler.METHOD_NAME) ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get(ErrorHandler.METHOD_NAME)) : ErrorHandler.UNKNOWN_METHOD;
            String fileName = frameInfo.containsKey(ErrorHandler.FILE_NAME) ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get(ErrorHandler.FILE_NAME)) : UNKNOWN_FILE;
            return new StackTraceElement(className, methodName, fileName, lineNumber.intValue());
        }

        private static String toStringOrNull(Object o) {
            return o == null ? null : o.toString();
        }
    }

    public static class UnknownServerException
    extends WebDriverException {
        private UnknownServerException(String s) {
            super(s);
        }
    }
}

