/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ReusingSocketSocketFactory;
import org.openqa.selenium.remote.SessionId;

public class HttpCommandExecutor
implements CommandExecutor {
    private static final int MAX_REDIRECTS = 10;
    private final HttpHost targetHost;
    private final URL remoteServer;
    private final Map<String, CommandInfo> nameToUrl;
    private final HttpClient client;

    private static ClientConnectionManager getClientConnectionManager(HttpParams httpParams) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)ReusingSocketSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        return new SingleClientConnManager(httpParams, registry);
    }

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        try {
            this.remoteServer = addressOfRemoteServer == null ? new URL(System.getProperty("webdriver.remote.server")) : addressOfRemoteServer;
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.socket.linger", (Object)-1);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        this.client = new DefaultHttpClient(HttpCommandExecutor.getClientConnectionManager((HttpParams)params), (HttpParams)params);
        if (addressOfRemoteServer.getUserInfo() != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(addressOfRemoteServer.getUserInfo());
            ((DefaultHttpClient)this.client).getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        String host = this.remoteServer.getHost().replace(".localdomain", "");
        this.targetHost = new HttpHost(host, this.remoteServer.getPort(), this.remoteServer.getProtocol());
        this.nameToUrl = ImmutableMap.builder().put((Object)"newSession", (Object)HttpCommandExecutor.post("/session")).put((Object)"quit", (Object)HttpCommandExecutor.delete("/session/:sessionId")).put((Object)"getCurrentWindowHandle", (Object)HttpCommandExecutor.get("/session/:sessionId/window_handle")).put((Object)"getWindowHandles", (Object)HttpCommandExecutor.get("/session/:sessionId/window_handles")).put((Object)"get", (Object)HttpCommandExecutor.post("/session/:sessionId/url")).put((Object)"dismissAlert", (Object)HttpCommandExecutor.post("/session/:sessionId/dismiss_alert")).put((Object)"acceptAlert", (Object)HttpCommandExecutor.post("/session/:sessionId/accept_alert")).put((Object)"getAlertText", (Object)HttpCommandExecutor.get("/session/:sessionId/alert_text")).put((Object)"setAlertValue", (Object)HttpCommandExecutor.post("/session/:sessionId/alert_text")).put((Object)"goForward", (Object)HttpCommandExecutor.post("/session/:sessionId/forward")).put((Object)"goBack", (Object)HttpCommandExecutor.post("/session/:sessionId/back")).put((Object)"refresh", (Object)HttpCommandExecutor.post("/session/:sessionId/refresh")).put((Object)"executeScript", (Object)HttpCommandExecutor.post("/session/:sessionId/execute")).put((Object)"executeAsyncScript", (Object)HttpCommandExecutor.post("/session/:sessionId/execute_async")).put((Object)"getCurrentUrl", (Object)HttpCommandExecutor.get("/session/:sessionId/url")).put((Object)"getTitle", (Object)HttpCommandExecutor.get("/session/:sessionId/title")).put((Object)"getPageSource", (Object)HttpCommandExecutor.get("/session/:sessionId/source")).put((Object)"screenshot", (Object)HttpCommandExecutor.get("/session/:sessionId/screenshot")).put((Object)"setBrowserVisible", (Object)HttpCommandExecutor.post("/session/:sessionId/visible")).put((Object)"isBrowserVisible", (Object)HttpCommandExecutor.get("/session/:sessionId/visible")).put((Object)"findElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element")).put((Object)"findElements", (Object)HttpCommandExecutor.post("/session/:sessionId/elements")).put((Object)"getActiveElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/active")).put((Object)"findChildElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/element")).put((Object)"findChildElements", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/elements")).put((Object)"clickElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/click")).put((Object)"clearElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/clear")).put((Object)"submitElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/submit")).put((Object)"getElementText", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/text")).put((Object)"sendKeysToElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/value")).put((Object)"getElementValue", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/value")).put((Object)"getElementTagName", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/name")).put((Object)"isElementSelected", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/selected")).put((Object)"setElementSelected", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/selected")).put((Object)"toggleElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/toggle")).put((Object)"isElementEnabled", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/enabled")).put((Object)"isElementDisplayed", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/displayed")).put((Object)"hoverOverElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/hover")).put((Object)"getElementLocation", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/location")).put((Object)"getElementLocationOnceScrolledIntoView", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/location_in_view")).put((Object)"getElementSize", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/size")).put((Object)"getElementAttribute", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/attribute/:name")).put((Object)"elementEquals", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/equals/:other")).put((Object)"getCookies", (Object)HttpCommandExecutor.get("/session/:sessionId/cookie")).put((Object)"addCookie", (Object)HttpCommandExecutor.post("/session/:sessionId/cookie")).put((Object)"deleteAllCookies", (Object)HttpCommandExecutor.delete("/session/:sessionId/cookie")).put((Object)"deleteCookie", (Object)HttpCommandExecutor.delete("/session/:sessionId/cookie/:name")).put((Object)"switchToFrame", (Object)HttpCommandExecutor.post("/session/:sessionId/frame")).put((Object)"switchToWindow", (Object)HttpCommandExecutor.post("/session/:sessionId/window")).put((Object)"close", (Object)HttpCommandExecutor.delete("/session/:sessionId/window")).put((Object)"dragElement", (Object)HttpCommandExecutor.post("/session/:sessionId/element/:id/drag")).put((Object)"getElementValueOfCssProperty", (Object)HttpCommandExecutor.get("/session/:sessionId/element/:id/css/:propertyName")).put((Object)"implicitlyWait", (Object)HttpCommandExecutor.post("/session/:sessionId/timeouts/implicit_wait")).put((Object)"setScriptTimeout", (Object)HttpCommandExecutor.post("/session/:sessionId/timeouts/async_script")).put((Object)"executeSQL", (Object)HttpCommandExecutor.post("/session/:sessionId/execute_sql")).put((Object)"getLocation", (Object)HttpCommandExecutor.get("/session/:sessionId/location")).put((Object)"setLocation", (Object)HttpCommandExecutor.post("/session/:sessionId/location")).put((Object)"getAppCache", (Object)HttpCommandExecutor.get("/session/:sessionId/application_cache")).put((Object)"getStatus", (Object)HttpCommandExecutor.get("/session/:sessionId/application_cache/status")).put((Object)"isBrowserOnline", (Object)HttpCommandExecutor.get("/session/:sessionId/browser_connection")).put((Object)"setBrowserOnline", (Object)HttpCommandExecutor.post("/session/:sessionId/browser_connection")).put((Object)"getLocalStorageItem", (Object)HttpCommandExecutor.get("/session/:sessionId/local_storage/:key")).put((Object)"removeLocalStorageItem", (Object)HttpCommandExecutor.delete("/session/:sessionId/local_storage/:key")).put((Object)"getLocalStorageKeys", (Object)HttpCommandExecutor.get("/session/:sessionId/local_storage")).put((Object)"setLocalStorageItem", (Object)HttpCommandExecutor.post("/session/:sessionId/local_storage")).put((Object)"clearLocalStorage", (Object)HttpCommandExecutor.delete("/session/:sessionId/local_storage")).put((Object)"getLocalStorageSize", (Object)HttpCommandExecutor.get("/session/:sessionId/local_storage/size")).put((Object)"getSessionStorageItem", (Object)HttpCommandExecutor.get("/session/:sessionId/session_storage/:key")).put((Object)"removeSessionStorageItem", (Object)HttpCommandExecutor.delete("/session/:sessionId/session_storage/:key")).put((Object)"getSessionStorageKey", (Object)HttpCommandExecutor.get("/session/:sessionId/session_storage")).put((Object)"setSessionStorageItem", (Object)HttpCommandExecutor.post("/session/:sessionId/session_storage")).put((Object)"clearSessionStorage", (Object)HttpCommandExecutor.delete("/session/:sessionId/session_storage")).put((Object)"getSessionStorageSize", (Object)HttpCommandExecutor.get("/session/:sessionId/session_storage/size")).put((Object)"getScreenOrientation", (Object)HttpCommandExecutor.get("/session/:sessionId/orientation")).put((Object)"setScreenOrientation", (Object)HttpCommandExecutor.post("/session/:sessionId/orientation")).put((Object)"mouseClick", (Object)HttpCommandExecutor.post("/session/:sessionId/click")).put((Object)"mouseDoubleClick", (Object)HttpCommandExecutor.post("/session/:sessionId/doubleclick")).put((Object)"mouseButtonDown", (Object)HttpCommandExecutor.post("/session/:sessionId/buttondown")).put((Object)"mouseButtonUp", (Object)HttpCommandExecutor.post("/session/:sessionId/buttonup")).put((Object)"mouseMoveTo", (Object)HttpCommandExecutor.post("/session/:sessionId/moveto")).put((Object)"sendModifierKeyToActiveElement", (Object)HttpCommandExecutor.post("/session/:sessionId/modifier")).put((Object)"imeGetAvailableEngines", (Object)HttpCommandExecutor.get("/session/:sessionId/ime/available_engines")).put((Object)"imeGetActiveEngine", (Object)HttpCommandExecutor.get("/session/:sessionId/ime/active_engine")).put((Object)"imeIsActivated", (Object)HttpCommandExecutor.get("/session/:sessionId/ime/activated")).put((Object)"imeDeactivate", (Object)HttpCommandExecutor.post("/session/:sessionId/ime/deactivate")).put((Object)"imeActivateEngine", (Object)HttpCommandExecutor.post("/session/:sessionId/ime/activate")).build();
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    public Response execute(Command command) throws IOException {
        BasicHttpContext context = new BasicHttpContext();
        CommandInfo info = this.nameToUrl.get(command.getName());
        try {
            HttpUriRequest httpMethod = info.getMethod(this.remoteServer, command);
            this.setAcceptHeader(httpMethod);
            if (httpMethod instanceof HttpPost) {
                String payload = new BeanToJsonConverter().convert(command.getParameters());
                ((HttpPost)httpMethod).setEntity((HttpEntity)new StringEntity(payload, "utf-8"));
                httpMethod.addHeader("Content-Type", "application/json; charset=utf-8");
            }
            HttpResponse response = this.fallBackExecute((HttpContext)context, httpMethod);
            response = this.followRedirects(this.client, (HttpContext)context, response, 0);
            EntityWithEncoding entityWithEncoding = new EntityWithEncoding(response.getEntity());
            return this.createResponse(response, (HttpContext)context, entityWithEncoding);
        }
        catch (NullPointerException e) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            throw e;
        }
    }

    private HttpResponse fallBackExecute(HttpContext context, HttpUriRequest httpMethod) throws IOException {
        try {
            return this.client.execute(this.targetHost, (HttpRequest)httpMethod, context);
        }
        catch (BindException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw Throwables.propagate((Throwable)ie);
            }
            return this.client.execute(this.targetHost, (HttpRequest)httpMethod, context);
        }
    }

    private void setAcceptHeader(HttpUriRequest httpMethod) {
        httpMethod.addHeader("Accept", "application/json, image/png");
    }

    private HttpResponse followRedirects(HttpClient client, HttpContext context, HttpResponse response, int redirectCount) {
        if (!this.isRedirect(response)) {
            return response;
        }
        if (redirectCount > 10) {
            throw new WebDriverException("Maximum number of redirects exceeded. Aborting");
        }
        String location = response.getFirstHeader("location").getValue();
        URI uri = null;
        try {
            uri = this.buildUri(context, location);
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                httpEntity.consumeContent();
            }
            HttpGet get = new HttpGet(uri);
            this.setAcceptHeader((HttpUriRequest)get);
            HttpResponse newResponse = client.execute(this.targetHost, (HttpRequest)get, context);
            return this.followRedirects(client, context, newResponse, redirectCount + 1);
        }
        catch (URISyntaxException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (ClientProtocolException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private URI buildUri(HttpContext context, String location) throws URISyntaxException {
        URI uri = new URI(location);
        if (!uri.isAbsolute()) {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            uri = new URI(host.toURI() + location);
        }
        return uri;
    }

    private boolean isRedirect(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && response.containsHeader("location");
    }

    private Response createResponse(HttpResponse httpResponse, HttpContext context, EntityWithEncoding entityWithEncoding) throws IOException {
        Response response;
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header != null && header.getValue().startsWith("application/json")) {
            String responseAsText = entityWithEncoding.getContentString();
            try {
                response = new JsonToBeanConverter().convert(Response.class, responseAsText);
            }
            catch (ClassCastException e) {
                if (responseAsText != null && "".equals(responseAsText)) {
                    return null;
                }
                throw new WebDriverException("Cannot convert text to response: " + responseAsText, (Throwable)e);
            }
        } else {
            int statusCode;
            int nextSlash;
            response = new Response();
            if (header != null && header.getValue().startsWith("image/png")) {
                response.setValue(entityWithEncoding.getContent());
            } else if (entityWithEncoding.hasEntityContent()) {
                response.setValue(entityWithEncoding.getContentString());
            }
            HttpHost finalHost = (HttpHost)context.getAttribute("http.target_host");
            String uri = finalHost.toURI();
            int sessionIndex = uri.indexOf("/session/");
            if (sessionIndex != -1 && (nextSlash = uri.indexOf("/", sessionIndex += "/session/".length())) != -1) {
                response.setSessionId(uri.substring(sessionIndex, nextSlash));
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) <= 199 || statusCode >= 300) {
                if (statusCode > 399 && statusCode < 500) {
                    response.setStatus(9);
                } else if (statusCode > 499 && statusCode < 600) {
                    if (response.getStatus() == 0) {
                        response.setStatus(13);
                    }
                } else {
                    response.setStatus(13);
                }
            }
            if (response.getValue() instanceof String) {
                response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
            }
        }
        return response;
    }

    private static CommandInfo get(String url) {
        return new CommandInfo(url, HttpVerb.GET);
    }

    private static CommandInfo post(String url) {
        return new CommandInfo(url, HttpVerb.POST);
    }

    private static CommandInfo delete(String url) {
        return new CommandInfo(url, HttpVerb.DELETE);
    }

    private static class CommandInfo {
        private final String url;
        private final HttpVerb verb;

        private CommandInfo(String url, HttpVerb verb) {
            this.url = url;
            this.verb = verb;
        }

        public HttpUriRequest getMethod(URL base, Command command) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(base.toExternalForm());
            for (String part : this.url.split("/")) {
                if (part.length() == 0) continue;
                urlBuilder.append("/");
                if (part.startsWith(":")) {
                    String value = this.get(part.substring(1), command);
                    if (value == null) continue;
                    urlBuilder.append(this.get(part.substring(1), command));
                    continue;
                }
                urlBuilder.append(part);
            }
            return this.verb.createMethod(urlBuilder.toString());
        }

        private String get(String propertyName, Command command) {
            if ("sessionId".equals(propertyName)) {
                SessionId id = command.getSessionId();
                if (id == null) {
                    throw new WebDriverException("Session ID may not be null");
                }
                return id.toString();
            }
            Object value = command.getParameters().get(propertyName);
            if (value != null) {
                return Urls.urlEncode(String.valueOf(value));
            }
            return null;
        }
    }

    class EntityWithEncoding {
        private final String charSet;
        private final byte[] content;

        EntityWithEncoding(HttpEntity entity) throws IOException {
            if (entity != null) {
                this.content = EntityUtils.toByteArray((HttpEntity)entity);
                this.charSet = EntityUtils.getContentCharSet((HttpEntity)entity);
                entity.consumeContent();
            } else {
                this.content = new byte[0];
                this.charSet = null;
            }
        }

        public String getContentString() throws UnsupportedEncodingException {
            return new String(this.content, this.charSet != null ? this.charSet : "utf-8");
        }

        public byte[] getContent() {
            return this.content;
        }

        public boolean hasEntityContent() {
            return this.content != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpVerb {
        GET{

            public HttpUriRequest createMethod(String url) {
                return new HttpGet(url);
            }
        }
        ,
        POST{

            public HttpUriRequest createMethod(String url) {
                return new HttpPost(url);
            }
        }
        ,
        DELETE{

            public HttpUriRequest createMethod(String url) {
                return new HttpDelete(url);
            }
        };


        public abstract HttpUriRequest createMethod(String var1);
    }
}

