/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.AddFindsByCss;
import org.openqa.selenium.remote.AddFindsChildByCss;
import org.openqa.selenium.remote.AddRotatable;
import org.openqa.selenium.remote.AddTakesScreenshot;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.html5.AddApplicationCache;
import org.openqa.selenium.remote.html5.AddBrowserConnection;
import org.openqa.selenium.remote.html5.AddDatabaseStorage;
import org.openqa.selenium.remote.html5.AddLocationContext;
import org.openqa.selenium.remote.html5.AddWebStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Augmenter {
    private final Map<String, AugmenterProvider> driverAugmentors = Maps.newHashMap();
    private final Map<String, AugmenterProvider> elementAugmentors = Maps.newHashMap();

    public Augmenter() {
        this.addDriverAugmentation("cssSelectorsEnabled", new AddFindsByCss());
        this.addDriverAugmentation("takesScreenshot", new AddTakesScreenshot());
        this.addDriverAugmentation("databaseEnabled", new AddDatabaseStorage());
        this.addDriverAugmentation("locationContextEnabled", new AddLocationContext());
        this.addDriverAugmentation("applicationCacheEnabled", new AddApplicationCache());
        this.addDriverAugmentation("browserConnectionEnabled", new AddBrowserConnection());
        this.addDriverAugmentation("webStorageEnabled", new AddWebStorage());
        this.addDriverAugmentation("rotatable", new AddRotatable());
        this.addElementAugmentation("cssSelectorsEnabled", new AddFindsChildByCss());
    }

    public void addDriverAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.driverAugmentors.put(capabilityName, handlerClass);
    }

    public void addElementAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.elementAugmentors.put(capabilityName, handlerClass);
    }

    public WebDriver augment(WebDriver driver) {
        if (!(driver instanceof RemoteWebDriver)) {
            return driver;
        }
        Map<String, AugmenterProvider> augmentors = this.driverAugmentors;
        CompoundHandler handler = this.determineAugmentation(driver, augmentors);
        RemoteWebDriver remote = this.create(handler, (RemoteWebDriver)driver);
        remote.setCommandExecutor(((RemoteWebDriver)driver).getCommandExecutor());
        remote.setElementConverter(((RemoteWebDriver)driver).getElementConverter());
        return remote;
    }

    public WebElement augment(RemoteWebElement element) {
        RemoteWebDriver parent = (RemoteWebDriver)element.getWrappedDriver();
        if (parent == null) {
            return element;
        }
        Map<String, AugmenterProvider> augmentors = this.elementAugmentors;
        CompoundHandler handler = this.determineAugmentation(parent, augmentors);
        RemoteWebElement remote = this.create(handler, element);
        remote.setId(element.getId());
        remote.setParent(parent);
        return remote;
    }

    private CompoundHandler determineAugmentation(WebDriver driver, Map<String, AugmenterProvider> augmentors) {
        Map capabilities = ((RemoteWebDriver)driver).getCapabilities().asMap();
        CompoundHandler handler = new CompoundHandler((RemoteWebDriver)driver);
        for (Map.Entry capablityName : capabilities.entrySet()) {
            Object value;
            AugmenterProvider augmenter = augmentors.get(capablityName.getKey());
            if (augmenter == null || (value = capablityName.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            handler.addCapabilityHander(augmenter.getDescribedInterface(), augmenter.getImplementation(value));
        }
        return handler;
    }

    protected <X> X create(CompoundHandler handler, X from) {
        if (handler.isNeedingApplication()) {
            Enhancer enhancer = new Enhancer();
            enhancer.setCallback((Callback)handler);
            enhancer.setSuperclass(from.getClass());
            HashSet interfaces = Sets.newHashSet();
            interfaces.addAll(handler.getInterfaces());
            enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            return (X)enhancer.create();
        }
        return from;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompoundHandler
    implements MethodInterceptor {
        private Map<Method, InterfaceImplementation> handlers = new HashMap<Method, InterfaceImplementation>();
        private Set<Class<?>> interfaces = new HashSet();
        private final RemoteWebDriver driver;

        private CompoundHandler(RemoteWebDriver driver) {
            this.driver = driver;
        }

        public void addCapabilityHander(Class<?> fromInterface, InterfaceImplementation handledBy) {
            this.interfaces.add(fromInterface);
            for (Method method : fromInterface.getDeclaredMethods()) {
                this.handlers.put(method, handledBy);
            }
        }

        public Set<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        public boolean isNeedingApplication() {
            return this.interfaces.size() > 0;
        }

        public Object intercept(Object self, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            InterfaceImplementation handler = this.handlers.get(method);
            if (handler == null) {
                return methodProxy.invokeSuper(self, args);
            }
            return handler.invoke(new ExecuteMethod(this.driver), self, method, args);
        }
    }
}

