/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.CommandHandler;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class GetLogsOfType
implements CommandHandler {
    private final JsonToBeanConverter toBean;
    private final ActiveSession session;

    public GetLogsOfType(JsonToBeanConverter toBean, ActiveSession session) {
        this.toBean = Objects.requireNonNull(toBean);
        this.session = Objects.requireNonNull(session);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        String originalPayload = req.getContentString();
        Map args = (Map)this.toBean.convert(Map.class, (Object)originalPayload);
        String type = (String)args.get("type");
        if (!"server".equals(type)) {
            HttpRequest upReq = new HttpRequest(HttpMethod.POST, String.format("/session/%s/log", this.session.getId()));
            upReq.setContent(originalPayload.getBytes(StandardCharsets.UTF_8));
            this.session.execute(upReq, resp);
            return;
        }
        LogEntries entries = LoggingManager.perSessionLogHandler().getSessionLog(this.session.getId());
        Response response = new Response(this.session.getId());
        response.setStatus(Integer.valueOf(0));
        response.setValue((Object)entries);
        this.session.getDownstreamDialect().getResponseCodec().encode(() -> resp, response);
    }
}

