/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonHttpCommandHandler;
import org.openqa.selenium.remote.server.SessionCleaner;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpc;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpcLoader;

public class DriverServlet
extends HttpServlet {
    public static final String SESSIONS_KEY = DriverServlet.class.getName() + ".sessions";
    public static final String SESSION_TIMEOUT_PARAMETER = "webdriver.server.session.timeout";
    public static final String BROWSER_TIMEOUT_PARAMETER = "webdriver.server.browser.timeout";
    private static final String CROSS_DOMAIN_RPC_PATH = "/xdrpc";
    private final StaticResourceHandler staticResourceHandler = new StaticResourceHandler();
    private final Supplier<DriverSessions> sessionsSupplier;
    private SessionCleaner sessionCleaner;
    private JsonHttpCommandHandler commandHandler;

    public DriverServlet() {
        this.sessionsSupplier = new DriverSessionsSupplier();
    }

    @VisibleForTesting
    DriverServlet(Supplier<DriverSessions> sessionsSupplier) {
        this.sessionsSupplier = sessionsSupplier;
    }

    public void init() throws ServletException {
        super.init();
        Logger logger = this.configureLogging();
        DriverSessions driverSessions = this.sessionsSupplier.get();
        this.commandHandler = new JsonHttpCommandHandler(driverSessions, logger);
        long sessionTimeOutInMs = this.getValueToUseInMs(SESSION_TIMEOUT_PARAMETER, 1800L);
        long browserTimeoutInMs = this.getValueToUseInMs(BROWSER_TIMEOUT_PARAMETER, 0L);
        if (sessionTimeOutInMs > 0L || browserTimeoutInMs > 0L) {
            this.createSessionCleaner(logger, driverSessions, sessionTimeOutInMs, browserTimeoutInMs);
        }
    }

    private synchronized Logger configureLogging() {
        Logger logger = this.getLogger();
        logger.addHandler((Handler)LoggingHandler.getInstance());
        Logger rootLogger = Logger.getLogger("");
        boolean sessionLoggerAttached = false;
        for (Handler handler : rootLogger.getHandlers()) {
            sessionLoggerAttached |= handler instanceof PerSessionLogHandler;
        }
        if (!sessionLoggerAttached) {
            rootLogger.addHandler(LoggingManager.perSessionLogHandler());
        }
        return logger;
    }

    @VisibleForTesting
    protected void createSessionCleaner(Logger logger, DriverSessions driverSessions, long sessionTimeOutInMs, long browserTimeoutInMs) {
        this.sessionCleaner = new SessionCleaner(driverSessions, logger, sessionTimeOutInMs, browserTimeoutInMs);
        this.sessionCleaner.start();
    }

    private long getValueToUseInMs(String propertyName, long defaultValue) {
        long time = defaultValue;
        String property = this.getServletContext().getInitParameter(propertyName);
        if (property != null) {
            time = Long.parseLong(property);
        }
        return TimeUnit.SECONDS.toMillis(time);
    }

    public void destroy() {
        this.getLogger().removeHandler((Handler)LoggingHandler.getInstance());
        if (this.sessionCleaner != null) {
            this.sessionCleaner.stopCleaner();
        }
    }

    protected Logger getLogger() {
        return Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getHeader("Origin") != null) {
            this.setAccessControlHeaders(response);
        }
        response.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        response.setHeader("Cache-Control", "no-cache");
        super.service(request, response);
    }

    private void setAccessControlHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "DELETE,GET,HEAD,POST");
        response.setHeader("Access-Control-Allow-Headers", "Accept,Content-Type");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo() == null || "/".equals(request.getPathInfo())) {
            this.staticResourceHandler.redirectToHub(request, response);
        } else if (this.staticResourceHandler.isStaticResourceRequest(request)) {
            this.staticResourceHandler.service(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (CROSS_DOMAIN_RPC_PATH.equalsIgnoreCase(request.getPathInfo())) {
            this.handleCrossDomainRpc(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    private void handleCrossDomainRpc(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        CrossDomainRpc rpc;
        try {
            rpc = new CrossDomainRpcLoader().loadRpc(servletRequest);
        }
        catch (IllegalArgumentException e) {
            servletResponse.setStatus(400);
            servletResponse.getOutputStream().println(e.getMessage());
            servletResponse.getOutputStream().flush();
            return;
        }
        HttpRequest request = new HttpRequest(HttpMethod.valueOf((String)rpc.getMethod()), rpc.getPath());
        request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        request.setContent(rpc.getContent());
        HttpResponse response = this.commandHandler.handleRequest(request);
        this.sendResponse(response, servletResponse);
    }

    protected void handleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        HttpRequest request = DriverServlet.createInternalRequest(servletRequest);
        HttpResponse response = this.commandHandler.handleRequest(request);
        this.sendResponse(response, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpRequest createInternalRequest(HttpServletRequest servletRequest) throws IOException {
        String path = servletRequest.getPathInfo();
        if (Strings.isNullOrEmpty((String)path)) {
            path = "/";
        }
        HttpRequest request = new HttpRequest(HttpMethod.valueOf((String)servletRequest.getMethod().toUpperCase()), path);
        Enumeration headerNames = servletRequest.getHeaderNames();
        for (String name : Collections.list(headerNames)) {
            Enumeration headerValues = servletRequest.getHeaders(name);
            for (String value : Collections.list(headerValues)) {
                request.setHeader(name, value);
            }
        }
        ServletInputStream stream = null;
        try {
            stream = servletRequest.getInputStream();
            request.setContent(ByteStreams.toByteArray((InputStream)stream));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return request;
    }

    private void sendResponse(HttpResponse response, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(response.getStatus());
        for (String name : response.getHeaderNames()) {
            for (String value : response.getHeaders(name)) {
                servletResponse.addHeader(name, value);
            }
        }
        ServletOutputStream output = servletResponse.getOutputStream();
        output.write(response.getContent());
        output.flush();
        output.close();
    }

    private static class StaticResourceHandler {
        private static final ImmutableMap<String, MediaType> MIME_TYPES = ImmutableMap.of((Object)"css", (Object)MediaType.CSS_UTF_8.withoutParameters(), (Object)"html", (Object)MediaType.HTML_UTF_8.withoutParameters(), (Object)"js", (Object)MediaType.JAVASCRIPT_UTF_8.withoutParameters());
        private static final String STATIC_RESOURCE_BASE_PATH = "/static/resource/";
        private static final String HUB_HTML_PATH = "/static/resource/hub.html";

        private StaticResourceHandler() {
        }

        public boolean isStaticResourceRequest(HttpServletRequest request) {
            return "GET".equalsIgnoreCase(request.getMethod()) && Strings.nullToEmpty((String)request.getPathInfo()).startsWith(STATIC_RESOURCE_BASE_PATH);
        }

        public void redirectToHub(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.sendRedirect(request.getContextPath() + request.getServletPath() + HUB_HTML_PATH);
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
            Preconditions.checkArgument((boolean)this.isStaticResourceRequest(request));
            String path = String.format("/%s/%s", StaticResourceHandler.class.getPackage().getName().replace(".", "/"), request.getPathInfo().substring(STATIC_RESOURCE_BASE_PATH.length()));
            URL url = StaticResourceHandler.class.getResource(path);
            if (url == null) {
                response.sendError(404);
                return;
            }
            response.setStatus(200);
            String extension = Files.getFileExtension((String)path);
            if (MIME_TYPES.containsKey((Object)extension)) {
                response.setContentType(((MediaType)MIME_TYPES.get((Object)extension)).toString());
            }
            byte[] data = this.getResourceData(url);
            response.setContentLength(data.length);
            ServletOutputStream output = response.getOutputStream();
            output.write(data);
            output.flush();
            output.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getResourceData(URL url) throws IOException {
            try (InputStream stream = null;){
                stream = url.openStream();
                byte[] byArray = ByteStreams.toByteArray((InputStream)stream);
                return byArray;
            }
        }
    }

    private class DriverSessionsSupplier
    implements Supplier<DriverSessions> {
        private DriverSessionsSupplier() {
        }

        @Override
        public DriverSessions get() {
            Object attribute = DriverServlet.this.getServletContext().getAttribute(SESSIONS_KEY);
            if (attribute == null) {
                attribute = new DefaultDriverSessions();
            }
            return (DriverSessions)attribute;
        }
    }
}

