/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerDriver
extends RemoteWebDriver
implements TakesScreenshot {
    private Pointer server;
    private IEServer lib;
    private int port;
    private WindowsProxyManager proxyManager;

    public InternetExplorerDriver() {
        this.setup();
    }

    public InternetExplorerDriver(Capabilities capabilities) {
        this.assertOnWindows();
        this.proxyManager = new WindowsProxyManager(true, "webdriver-ie", 0, 0);
        this.prepareProxy(capabilities);
        this.setup();
    }

    public InternetExplorerDriver(int port) {
        this.port = port;
        this.setup();
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    protected void assertOnWindows() {
        Platform current = Platform.getCurrent();
        if (!current.is(Platform.WINDOWS)) {
            throw new WebDriverException(String.format("You appear to be running %s. The IE driver only runs on Windows.", current));
        }
    }

    private void setup() {
        if (this.port == 0) {
            this.port = PortProber.findFreePort();
        }
        this.startClient();
        this.setCommandExecutor((CommandExecutor)new HttpCommandExecutor(InternetExplorerDriver.getServerUrl(this.port)));
        this.setElementConverter(new JsonToWebElementConverter(this){

            protected RemoteWebElement newRemoteWebElement() {
                return new InternetExplorerElement(InternetExplorerDriver.this);
            }
        });
        this.startSession((Capabilities)DesiredCapabilities.internetExplorer());
    }

    protected void startClient() {
        this.initializeLib();
        this.server = this.lib.StartServer(this.port);
    }

    protected void stopClient() {
        if (this.server != null) {
            this.lib.StopServer(this.server);
        }
    }

    private static URL getServerUrl(int port) {
        try {
            return new URL("http://localhost:" + port);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLib() {
        InternetExplorerDriver internetExplorerDriver = this;
        synchronized (internetExplorerDriver) {
            if (this.lib != null) {
                return;
            }
            File parentDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("webdriver", "libs");
            try {
                FileHandler.copyResource((File)parentDir, ((Object)((Object)this)).getClass(), (String[])new String[]{"IEDriver.dll"});
            }
            catch (IOException ioe) {
                try {
                    if (Boolean.getBoolean("webdriver.development")) {
                        String arch = System.getProperty("os.arch", "").contains("64") ? "x64" : "Win32";
                        ArrayList<String> sourcePaths = new ArrayList<String>();
                        sourcePaths.add("build\\cpp\\" + arch + "\\Debug");
                        sourcePaths.add("..\\build\\cpp\\" + arch + "\\Debug");
                        sourcePaths.add("..\\..\\build\\cpp\\" + arch + "\\Debug");
                        boolean copied = false;
                        for (String path : sourcePaths) {
                            File sourceFile = new File(path, "IEDriver.dll");
                            if (!sourceFile.exists()) continue;
                            FileHandler.copy((File)sourceFile, (File)new File(parentDir, "IEDriver.dll"));
                            copied = true;
                            break;
                        }
                        if (!copied) {
                            throw new WebDriverException("Couldn't find IEDriver.dll: " + arch);
                        }
                    }
                    throw new WebDriverException((Throwable)ioe);
                }
                catch (IOException ioe2) {
                    throw new WebDriverException((Throwable)ioe2);
                }
            }
            System.setProperty("jna.library.path", System.getProperty("jna.library.path", "") + File.pathSeparator + parentDir);
            try {
                this.lib = (IEServer)Native.loadLibrary((String)"IEDriver", IEServer.class);
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("new File(\".\").getAbsolutePath() = " + new File(".").getAbsolutePath());
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private void prepareProxy(Capabilities caps) {
        if (caps == null || caps.getCapability("proxy") == null) {
            return;
        }
        try {
            this.proxyManager.backupRegistrySettings();
            this.proxyManager.changeRegistrySettings(caps);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        Thread cleanupThread = new Thread(){

            public void run() {
                InternetExplorerDriver.this.proxyManager.restoreRegistrySettings(true);
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }

    private static interface IEServer
    extends StdCallLibrary {
        public Pointer StartServer(int var1);

        public void StopServer(Pointer var1);
    }
}

