/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.IllegalLocatorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.ElementCollection;
import org.openqa.selenium.ie.ErrorHandler;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.ie.UnexpectedJavascriptExecutionException;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Finder
implements SearchContext,
FindsByClassName,
FindsById,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath {
    private final ExportedWebDriverFunctions lib;
    private final InternetExplorerDriver parent;
    private final Pointer driver;
    private final Pointer element;

    public Finder(ExportedWebDriverFunctions lib, InternetExplorerDriver parent, Pointer element) {
        this.lib = lib;
        this.parent = parent;
        this.driver = parent.getUnderlyingPointer();
        this.element = element;
    }

    public WebElement findElementByClassName(String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (using.matches(".*\\s+.*")) {
            throw new IllegalLocatorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementByClassName(this.driver, this.element, new WString(using), rawElement);
        this.handleErrorCode("class name", using, result);
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsByClassName(String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (using.matches(".*\\s+.*")) {
            throw new IllegalLocatorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsByClassName(this.driver, this.element, new WString(using), elements);
        this.handleErrorCode("class name", using, result);
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElementById(String using) {
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementById(this.driver, this.element, new WString(using), rawElement);
        this.handleErrorCode("id", using, result);
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsById(String using) {
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsById(this.driver, this.element, new WString(using), elements);
        this.handleErrorCode("id", using, result);
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElementByLinkText(String using) {
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementByLinkText(this.driver, this.element, new WString(using), rawElement);
        this.handleErrorCode("link text", using, result);
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsByLinkText(String using) {
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsByLinkText(this.driver, this.element, new WString(using), elements);
        this.handleErrorCode("link text", using, result);
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElementByPartialLinkText(String using) {
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementByPartialLinkText(this.driver, this.element, new WString(using), rawElement);
        this.handleErrorCode("link text", using, result);
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsByPartialLinkText(this.driver, this.element, new WString(using), elements);
        this.handleErrorCode("link text", using, result);
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElementByName(String using) {
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementByName(this.driver, this.element, new WString(using), rawElement);
        this.handleErrorCode("name", using, result);
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsByName(String using) {
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsByName(this.driver, this.element, new WString(using), elements);
        this.handleErrorCode("name", using, result);
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElementByTagName(String using) {
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementByTagName(this.driver, this.element, new WString(using), rawElement);
        this.handleErrorCode("xpath", using, result);
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsByTagName(String using) {
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsByTagName(this.driver, this.element, new WString(using), elements);
        this.handleErrorCode("tag name", using, result);
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElementByXPath(String using) {
        PointerByReference rawElement = new PointerByReference();
        int result = this.lib.wdFindElementByXPath(this.driver, this.element, new WString(using), rawElement);
        try {
            this.handleErrorCode("xpath", using, result);
        }
        catch (UnexpectedJavascriptExecutionException e) {
            throw new NoSuchElementException("Unable to find element by xpath: " + using);
        }
        return new InternetExplorerElement(this.lib, this.parent, rawElement.getValue());
    }

    public List<WebElement> findElementsByXPath(String using) {
        PointerByReference elements = new PointerByReference();
        int result = this.lib.wdFindElementsByXPath(this.driver, this.element, new WString(using), elements);
        try {
            this.handleErrorCode("xpath", using, result);
        }
        catch (UnexpectedJavascriptExecutionException e) {
            throw new NoSuchElementException("Unable to find element by xpath: " + using);
        }
        return new ElementCollection(this.lib, this.parent, elements.getValue()).toList();
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    private void handleErrorCode(String how, String using, int errorCode) {
        ErrorHandler errors = new ErrorHandler();
        String message = String.format("Unable to find element by %s using \"%s\" (%d)", how, using, errorCode);
        errors.verifyErrorCode(errorCode, message);
    }
}

