/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.TimedOutException;
import org.openqa.selenium.ie.UnexpectedJavascriptExecutionException;

class ErrorHandler {
    ErrorHandler() {
    }

    public void verifyErrorCode(int errorCode, String message) {
        switch (errorCode) {
            case 0: {
                break;
            }
            case 7: {
                throw new NoSuchElementException(message);
            }
            case 8: {
                throw new NoSuchFrameException(message);
            }
            case 9: {
                throw new UnsupportedOperationException("You may not perform the requested action");
            }
            case 10: {
                throw new StaleElementReferenceException(String.format("You may not %s this element. It looks as if the reference is stale. Did you navigate away from the page with this element on?", message));
            }
            case 11: {
                throw new ElementNotVisibleException(String.format("You may not %s an element that is not displayed", message));
            }
            case 12: {
                throw new UnsupportedOperationException(String.format("You may not %s an element that is not enabled", message));
            }
            case 14: {
                throw new WebDriverException("An unhandled exception has occured. " + message);
            }
            case 15: {
                throw new UnsupportedOperationException(String.format("The element appears to be unselectable: %s", message));
            }
            case 16: {
                throw new NoSuchElementException(message + " (no document found)");
            }
            case 17: {
                throw new UnexpectedJavascriptExecutionException(message);
            }
            case 21: {
                throw new TimedOutException("The driver reported that the command timed out. There may be several reasons for this. Check that the destinationsite is in IE's 'Trusted Sites' (accessed from Tools->Internet Options in the 'Security' tab) If it is a trusted site, then the request may have taken more thana minute to finish.");
            }
            case 23: {
                throw new NoSuchWindowException(message);
            }
            default: {
                throw new IllegalStateException(String.format("%s (%d)", message, errorCode));
            }
        }
    }
}

