/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.ErrorHandler;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;
import org.openqa.selenium.ie.Finder;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.StringWrapper;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerElement
implements RenderedWebElement,
Locatable {
    private final ExportedWebDriverFunctions lib;
    private final InternetExplorerDriver parent;
    private final Pointer element;
    private final ErrorHandler errors = new ErrorHandler();

    public InternetExplorerElement(ExportedWebDriverFunctions lib, InternetExplorerDriver parent, Pointer element) {
        this.lib = lib;
        this.parent = parent;
        this.element = element;
        if (element == null) {
            throw new IllegalStateException("Element pointer is null.");
        }
    }

    public void click() {
        int result = this.lib.wdeClick(this.element);
        this.errors.verifyErrorCode(result, "click");
    }

    public String getTagName() {
        PointerByReference wrapper = new PointerByReference();
        int result = this.lib.wdeGetTagName(this.element, wrapper);
        this.errors.verifyErrorCode(result, "element name");
        return new StringWrapper(this.lib, wrapper).toString();
    }

    public String getAttribute(String name) {
        PointerByReference wrapper = new PointerByReference();
        int result = this.lib.wdeGetAttribute(this.element, new WString(name), wrapper);
        this.errors.verifyErrorCode(result, "get attribute of");
        return new StringWrapper(this.lib, wrapper).toString();
    }

    public String getText() {
        PointerByReference wrapper = new PointerByReference();
        int result = this.lib.wdeGetText(this.element, wrapper);
        this.errors.verifyErrorCode(result, "get text of");
        return new StringWrapper(this.lib, wrapper).toString().replace("\r\n", "\n");
    }

    public String getValue() {
        return this.getAttribute("value").replace("\r\n", "\n");
    }

    public void sendKeys(CharSequence ... value) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        int result = this.lib.wdeSendKeys(this.element, new WString(builder.toString()));
        this.errors.verifyErrorCode(result, "send keys to");
        this.parent.waitForLoadToComplete();
    }

    public void clear() {
        int result = this.lib.wdeClear(this.element);
        this.errors.verifyErrorCode(result, "clear");
    }

    public boolean isEnabled() {
        IntByReference selected = new IntByReference();
        int result = this.lib.wdeIsEnabled(this.element, selected);
        this.errors.verifyErrorCode(result, "get enabled state");
        return selected.getValue() == 1;
    }

    public boolean isSelected() {
        IntByReference selected = new IntByReference();
        int result = this.lib.wdeIsSelected(this.element, selected);
        this.errors.verifyErrorCode(result, "get selected state");
        return selected.getValue() == 1;
    }

    public void setSelected() {
        int result = this.lib.wdeSetSelected(this.element);
        this.errors.verifyErrorCode(result, "select");
    }

    public void hover() {
        ExportedWebDriverFunctions.HWNDByReference hwnd = new ExportedWebDriverFunctions.HWNDByReference();
        NativeLongByReference x = new NativeLongByReference();
        NativeLongByReference y = new NativeLongByReference();
        NativeLongByReference width = new NativeLongByReference();
        NativeLongByReference height = new NativeLongByReference();
        int result = this.lib.wdeGetDetailsOnceScrolledOnToScreen(this.element, hwnd, x, y, width, height);
        this.errors.verifyErrorCode(result, "hover");
        long midX = x.getValue().longValue() + width.getValue().longValue() / 2L;
        long midY = y.getValue().longValue() + height.getValue().longValue() / 2L;
        result = this.lib.wdeMouseMoveTo(hwnd.getValue(), new NativeLong(100L), new NativeLong(0L), new NativeLong(0L), new NativeLong(midX), new NativeLong(midY));
        this.errors.verifyErrorCode(result, "hover mouse move");
    }

    public void submit() {
        int result = this.lib.wdeSubmit(this.element);
        this.errors.verifyErrorCode(result, "submit");
    }

    public boolean toggle() {
        IntByReference toReturn = new IntByReference();
        int result = this.lib.wdeToggle(this.element, toReturn);
        if (result == 9) {
            throw new UnsupportedOperationException("You may not toggle this element: " + this.getTagName());
        }
        this.errors.verifyErrorCode(result, "toggle");
        return toReturn.getValue() == 1;
    }

    public boolean isDisplayed() {
        IntByReference displayed = new IntByReference();
        int result = this.lib.wdeIsDisplayed(this.element, displayed);
        this.errors.verifyErrorCode(result, "clear");
        return displayed.getValue() == 1;
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        ExportedWebDriverFunctions.HWNDByReference hwnd = new ExportedWebDriverFunctions.HWNDByReference();
        NativeLongByReference x = new NativeLongByReference();
        NativeLongByReference y = new NativeLongByReference();
        NativeLongByReference width = new NativeLongByReference();
        NativeLongByReference height = new NativeLongByReference();
        if (this.lib.wdeGetDetailsOnceScrolledOnToScreen(this.element, hwnd, x, y, width, height) != 0) {
            return null;
        }
        return new Point(x.getValue().intValue(), y.getValue().intValue());
    }

    public Point getLocation() {
        NativeLongByReference x = new NativeLongByReference();
        NativeLongByReference y = new NativeLongByReference();
        int result = this.lib.wdeGetLocation(this.element, x, y);
        this.errors.verifyErrorCode(result, "Unable to get location of element");
        return new Point(x.getValue().intValue(), y.getValue().intValue());
    }

    public Dimension getSize() {
        NativeLongByReference width = new NativeLongByReference();
        NativeLongByReference height = new NativeLongByReference();
        int result = this.lib.wdeGetSize(this.element, width, height);
        this.errors.verifyErrorCode(result, "Unable to get element size");
        return new Dimension(width.getValue().intValue(), height.getValue().intValue());
    }

    public String getValueOfCssProperty(String propertyName) {
        PointerByReference wrapper = new PointerByReference();
        int result = this.lib.wdeGetValueOfCssProperty(this.element, new WString(propertyName), wrapper);
        this.errors.verifyErrorCode(result, "Unable to get value of css property: " + propertyName);
        return new StringWrapper(this.lib, wrapper).toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.lib.wdeFreeElement(this.element);
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        ExportedWebDriverFunctions.HWNDByReference hwnd = new ExportedWebDriverFunctions.HWNDByReference();
        NativeLongByReference x = new NativeLongByReference();
        NativeLongByReference y = new NativeLongByReference();
        NativeLongByReference width = new NativeLongByReference();
        NativeLongByReference height = new NativeLongByReference();
        int result = this.lib.wdeGetDetailsOnceScrolledOnToScreen(this.element, hwnd, x, y, width, height);
        this.errors.verifyErrorCode(result, "Unable to determine location once scrolled on to screen");
        this.lib.wdeMouseDownAt(hwnd.getValue(), x.getValue(), y.getValue());
        long endX = x.getValue().longValue() + (long)moveRightBy;
        long endY = y.getValue().longValue() + (long)moveDownBy;
        int duration = this.parent.manage().getSpeed().getTimeOut();
        this.lib.wdeMouseMoveTo(hwnd.getValue(), new NativeLong((long)duration), x.getValue(), y.getValue(), new NativeLong(endX), new NativeLong(endY));
        this.lib.wdeMouseUpAt(hwnd.getValue(), new NativeLong(endX), new NativeLong(endY));
    }

    public void dragAndDropOn(RenderedWebElement toElement) {
        ExportedWebDriverFunctions.HWNDByReference hwnd = new ExportedWebDriverFunctions.HWNDByReference();
        NativeLongByReference x = new NativeLongByReference();
        NativeLongByReference y = new NativeLongByReference();
        NativeLongByReference width = new NativeLongByReference();
        NativeLongByReference height = new NativeLongByReference();
        int result = this.lib.wdeGetDetailsOnceScrolledOnToScreen(this.element, hwnd, x, y, width, height);
        this.errors.verifyErrorCode(result, "Unable to determine location once scrolled on to screen");
        NativeLong startX = new NativeLong(x.getValue().longValue() + width.getValue().longValue() / 2L);
        NativeLong startY = new NativeLong(y.getValue().longValue() + height.getValue().longValue() / 2L);
        this.lib.wdeMouseDownAt(hwnd.getValue(), startX, startY);
        Pointer other = ((InternetExplorerElement)toElement).element;
        result = this.lib.wdeGetDetailsOnceScrolledOnToScreen(other, hwnd, x, y, width, height);
        this.errors.verifyErrorCode(result, "Unable to determine location of target once scrolled on to screen");
        NativeLong endX = new NativeLong(x.getValue().longValue() + width.getValue().longValue() / 2L);
        NativeLong endY = new NativeLong(y.getValue().longValue() + height.getValue().longValue() / 2L);
        int duration = this.parent.manage().getSpeed().getTimeOut();
        this.lib.wdeMouseMoveTo(hwnd.getValue(), new NativeLong((long)duration), startX, startY, endX, endY);
        this.lib.wdeMouseUpAt(hwnd.getValue(), endX, endY);
    }

    public WebElement findElement(By by) {
        return new Finder(this.lib, this.parent, this.element).findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return new Finder(this.lib, this.parent, this.element).findElements(by);
    }

    protected int addToScriptArgs(Pointer scriptArgs) {
        return this.lib.wdAddElementScriptArg(scriptArgs, this.element);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        if (!(other instanceof InternetExplorerElement)) {
            return false;
        }
        Boolean result = (Boolean)this.parent.executeScript("return arguments[0] === arguments[1];", this, other);
        return result != null && result != false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

