/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.openqa.selenium.remote.http.Message;

public class BinaryMessage
implements Message {
    private final byte[] data;

    public BinaryMessage(ByteBuffer data) {
        Objects.requireNonNull(data, "Data to use must be set.");
        ByteBuffer copy = data.asReadOnlyBuffer();
        this.data = new byte[copy.capacity()];
        copy.get(this.data);
    }

    public BinaryMessage(byte[] data) {
        Objects.requireNonNull(data, "Data to use must be set.");
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public byte[] data() {
        return this.data;
    }
}

