/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.collect.ImmutableSet;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.router.GridStatusHandler;
import org.openqa.selenium.grid.router.HandleSession;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public class Router
implements HasReadyState,
Routable {
    private final Routable routes;
    private final SessionMap sessions;
    private final Distributor distributor;
    private final NewSessionQueue queue;

    public Router(Tracer tracer, HttpClient.Factory clientFactory, SessionMap sessions, NewSessionQueue queue, Distributor distributor) {
        Require.nonNull((String)"Tracer to use", (Object)tracer);
        Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        this.queue = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)queue);
        this.distributor = (Distributor)Require.nonNull((String)"Distributor", (Object)distributor);
        HandleSession sessionHandler = new HandleSession(tracer, clientFactory, sessions);
        this.routes = Route.combine((Routable)Route.get((String)"/status").to(() -> new GridStatusHandler(tracer, distributor)), (Routable[])new Routable[]{sessions.with((Filter)new SpanDecorator(tracer, req -> "session_map")), queue.with((Filter)new SpanDecorator(tracer, req -> "session_queue")), distributor.with((Filter)new SpanDecorator(tracer, req -> "distributor")), Route.matching(req -> req.getUri().startsWith("/session/")).to(() -> sessionHandler)});
    }

    @Override
    public boolean isReady() {
        try {
            return ImmutableSet.of((Object)this.distributor, (Object)this.sessions, (Object)this.queue).parallelStream().map(rec$ -> ((HasReadyState)rec$).isReady()).reduce(true, Boolean::logicalAnd);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

