/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasDownloads;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.concurrent.GuardedRunnable;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeDrainStarted;
import org.openqa.selenium.grid.data.NodeHeartBeatEvent;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedReason;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.CapabilityResponseEncoder;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.docker.DockerSession;
import org.openqa.selenium.grid.node.local.SessionSlot;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService(objectName="org.seleniumhq.grid:type=Node,name=LocalNode", description="Node running the webdriver sessions.")
public class LocalNode
extends Node
implements Closeable {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(LocalNode.class.getName());
    private static final DateTimeFormatter HTTP_DATE_FORMAT = DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(Locale.US);
    private final EventBus bus;
    private final URI externalUri;
    private final URI gridUri;
    private final Duration heartbeatPeriod;
    private final HealthCheck healthCheck;
    private final int maxSessionCount;
    private final int configuredSessionCount;
    private final boolean cdpEnabled;
    private final boolean managedDownloadsEnabled;
    private final int connectionLimitPerSession;
    private final boolean bidiEnabled;
    private final boolean drainAfterSessions;
    private final List<SessionSlot> factories;
    private final Cache<SessionId, SessionSlot> currentSessions;
    private final Cache<SessionId, TemporaryFilesystem> uploadsTempFileSystem;
    private final Cache<SessionId, TemporaryFilesystem> downloadsTempFileSystem;
    private final AtomicInteger pendingSessions = new AtomicInteger();
    private final AtomicInteger sessionCount = new AtomicInteger();
    private final Runnable shutdown;
    private final ReadWriteLock drainLock = new ReentrantReadWriteLock();

    protected LocalNode(Tracer tracer, EventBus bus, URI uri, URI gridUri, HealthCheck healthCheck, int maxSessionCount, int drainAfterSessionCount, boolean cdpEnabled, boolean bidiEnabled, Ticker ticker, Duration sessionTimeout, Duration heartbeatPeriod, List<SessionSlot> factories, Secret registrationSecret, boolean managedDownloadsEnabled, int connectionLimitPerSession) {
        super(tracer, new NodeId(UUID.randomUUID()), uri, registrationSecret, Require.positive((Duration)sessionTimeout));
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.externalUri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
        this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
        this.maxSessionCount = Math.min(Require.positive((String)"Max session count", (Integer)maxSessionCount), factories.size());
        this.heartbeatPeriod = heartbeatPeriod;
        this.factories = ImmutableList.copyOf(factories);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.configuredSessionCount = drainAfterSessionCount;
        this.drainAfterSessions = this.configuredSessionCount > 0;
        this.sessionCount.set(drainAfterSessionCount);
        this.cdpEnabled = cdpEnabled;
        this.bidiEnabled = bidiEnabled;
        this.managedDownloadsEnabled = managedDownloadsEnabled;
        this.connectionLimitPerSession = connectionLimitPerSession;
        this.healthCheck = healthCheck == null ? () -> {
            NodeStatus status = this.getStatus();
            return new HealthCheck.Result(status.getAvailability(), String.format("%s is %s", new Object[]{uri, status.getAvailability()}));
        } : healthCheck;
        this.uploadsTempFileSystem = Caffeine.newBuilder().removalListener((key, tempFS, cause) -> Optional.ofNullable(tempFS).ifPresent(fs -> {
            fs.deleteTemporaryFiles();
            fs.deleteBaseDir();
        })).build();
        this.downloadsTempFileSystem = Caffeine.newBuilder().removalListener((key, tempFS, cause) -> Optional.ofNullable(tempFS).ifPresent(fs -> {
            fs.deleteTemporaryFiles();
            fs.deleteBaseDir();
        })).build();
        this.currentSessions = Caffeine.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(this::stopTimedOutSession).build();
        ScheduledExecutorService sessionCleanupNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Local Node - Session Cleanup " + String.valueOf(this.externalUri));
            return thread;
        });
        sessionCleanupNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.currentSessions.cleanUp()), 30L, 30L, TimeUnit.SECONDS);
        ScheduledExecutorService uploadTempFileCleanupNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("UploadTempFile Cleanup Node " + String.valueOf(this.externalUri));
            return thread;
        });
        uploadTempFileCleanupNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.uploadsTempFileSystem.cleanUp()), 30L, 30L, TimeUnit.SECONDS);
        ScheduledExecutorService downloadTempFileCleanupNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("DownloadTempFile Cleanup Node " + String.valueOf(this.externalUri));
            return thread;
        });
        downloadTempFileCleanupNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.downloadsTempFileSystem.cleanUp()), 30L, 30L, TimeUnit.SECONDS);
        ScheduledExecutorService heartbeatNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("HeartBeat Node " + String.valueOf(this.externalUri));
            return thread;
        });
        heartbeatNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> bus.fire(new NodeHeartBeatEvent(this.getStatus()))), heartbeatPeriod.getSeconds(), heartbeatPeriod.getSeconds(), TimeUnit.SECONDS);
        this.shutdown = () -> {
            if (heartbeatNodeService.isShutdown()) {
                return;
            }
            ExecutorServices.shutdownGracefully((String)("Local Node - Session Cleanup " + String.valueOf(this.externalUri)), (ExecutorService)sessionCleanupNodeService);
            ExecutorServices.shutdownGracefully((String)("UploadTempFile Cleanup Node " + String.valueOf(this.externalUri)), (ExecutorService)uploadTempFileCleanupNodeService);
            ExecutorServices.shutdownGracefully((String)("DownloadTempFile Cleanup Node " + String.valueOf(this.externalUri)), (ExecutorService)downloadTempFileCleanupNodeService);
            ExecutorServices.shutdownGracefully((String)("HeartBeat Node " + String.valueOf(this.externalUri)), (ExecutorService)heartbeatNodeService);
            this.currentSessions.invalidateAll();
            this.currentSessions.cleanUp();
        };
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stopAllSessions();
            this.drain();
        }));
        new JMXHelper().register(this);
    }

    @Override
    public void close() {
        this.shutdown.run();
    }

    private void stopTimedOutSession(SessionId id, SessionSlot slot, RemovalCause cause) {
        block14: {
            try (Span span = this.tracer.getCurrentContext().createSpan("node.stop_session");){
                AttributeMap attributeMap = this.tracer.createAttributeMap();
                attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
                if (id != null && slot != null) {
                    SessionClosedReason closeReason;
                    attributeMap.put("node.id", this.getId().toString());
                    attributeMap.put("session.slotId", slot.getId().toString());
                    attributeMap.put("session.id", id.toString());
                    attributeMap.put("session.timeout_in_seconds", this.getSessionTimeout().toSeconds());
                    attributeMap.put("session.remove.cause", cause.name());
                    if (cause == RemovalCause.EXPIRED) {
                        closeReason = SessionClosedReason.TIMEOUT;
                        LOG.log(Level.INFO, () -> String.format("Session id %s timed out, stopping...", id));
                        span.setStatus(Status.CANCELLED);
                        span.addEvent(String.format("Stopping the the timed session %s", id), attributeMap);
                    } else {
                        closeReason = SessionClosedReason.QUIT_COMMAND;
                        LOG.log(Level.INFO, () -> String.format("Session id %s is stopping on demand...", id));
                        span.addEvent(String.format("Stopping the session %s on demand", id), attributeMap);
                    }
                    if (cause == RemovalCause.EXPIRED) {
                        try {
                            slot.execute(new HttpRequest(HttpMethod.DELETE, "/session/" + String.valueOf(id)));
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, String.format("Exception while trying to stop session %s", id), e);
                            span.setStatus(Status.INTERNAL);
                            span.addEvent(String.format("Exception while trying to stop session %s", id), attributeMap);
                        }
                    }
                    slot.stop(closeReason);
                    if (this.isDraining()) {
                        int done = this.pendingSessions.decrementAndGet();
                        attributeMap.put("current.session.count", (long)done);
                        attributeMap.put("node.drain_after_session_count", (long)this.configuredSessionCount);
                        if (done <= 0) {
                            LOG.info("Node draining complete!");
                            this.bus.fire(new NodeDrainComplete(this.getId()));
                            span.addEvent("Node draining complete!", attributeMap);
                        }
                    }
                    break block14;
                }
                LOG.log(Debug.getDebugLogLevel(), "Received stop session notification with null values");
                span.setStatus(Status.INVALID_ARGUMENT);
                span.addEvent("Received stop session notification with null values", attributeMap);
            }
        }
    }

    public static Builder builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, Secret registrationSecret) {
        return new Builder(tracer, bus, uri, gridUri, registrationSecret);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @ManagedAttribute(name="CurrentSessions")
    @VisibleForTesting
    public int getCurrentSessionCount() {
        long n = this.currentSessions.asMap().values().stream().count();
        return Math.toIntExact(n);
    }

    @ManagedAttribute(name="MaxSessions")
    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    @ManagedAttribute(name="Status")
    public Availability getAvailability() {
        return this.isDraining() ? Availability.DRAINING : Availability.UP;
    }

    @ManagedAttribute(name="TotalSlots")
    public int getTotalSlots() {
        return this.factories.size();
    }

    @ManagedAttribute(name="UsedSlots")
    public long getUsedSlots() {
        return this.factories.stream().filter(sessionSlot -> !sessionSlot.isAvailable()).count();
    }

    @ManagedAttribute(name="Load")
    public float getLoad() {
        long inUse = this.factories.stream().filter(sessionSlot -> !sessionSlot.isAvailable()).count();
        return (float)inUse / (float)this.maxSessionCount * 100.0f;
    }

    @ManagedAttribute(name="RemoteNodeUri")
    public URI getExternalUri() {
        return this.getUri();
    }

    @ManagedAttribute(name="GridUri")
    public URI getGridUri() {
        return this.gridUri;
    }

    @ManagedAttribute(name="NodeId")
    public String getNodeId() {
        return this.getId().toString();
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.factories.parallelStream().anyMatch(factory -> factory.test(capabilities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<WebDriverException, CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Require.nonNull((String)"Session request", (Object)sessionRequest);
        Lock lock = this.drainLock.readLock();
        lock.lock();
        try {
            Either either;
            block37: {
                Either<WebDriverException, ActiveSession> possibleSession;
                TemporaryFilesystem downloadsTfs;
                SessionSlot slotToUse;
                AttributeMap attributeMap;
                Span span;
                block35: {
                    Either either2;
                    block36: {
                        block33: {
                            Either either3;
                            block34: {
                                block31: {
                                    block32: {
                                        block29: {
                                            Either either4;
                                            block30: {
                                                block27: {
                                                    Either either5;
                                                    block28: {
                                                        span = this.tracer.getCurrentContext().createSpan("node.new_session");
                                                        attributeMap = this.tracer.createAttributeMap();
                                                        attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
                                                        attributeMap.put("session.request.capabilities", sessionRequest.getDesiredCapabilities().toString());
                                                        attributeMap.put("session.request.downstreamdialect", sessionRequest.getDownstreamDialects().toString());
                                                        int currentSessionCount = this.getCurrentSessionCount();
                                                        span.setAttribute("current.session.count", (Number)currentSessionCount);
                                                        attributeMap.put("current.session.count", (long)currentSessionCount);
                                                        if (currentSessionCount < this.maxSessionCount) break block27;
                                                        span.setAttribute(AttributeKey.ERROR.getKey(), true);
                                                        span.setStatus(Status.RESOURCE_EXHAUSTED);
                                                        attributeMap.put("max.session.count", (long)this.maxSessionCount);
                                                        span.addEvent("Max session count reached", attributeMap);
                                                        either5 = Either.left((Object)new RetrySessionRequestException("Max session count reached."));
                                                        if (span == null) break block28;
                                                        span.close();
                                                    }
                                                    return either5;
                                                }
                                                if (!this.isDraining()) break block29;
                                                span.setStatus(Status.UNAVAILABLE.withDescription("The node is draining. Cannot accept new sessions."));
                                                either4 = Either.left((Object)new RetrySessionRequestException("The node is draining. Cannot accept new sessions."));
                                                if (span == null) break block30;
                                                span.close();
                                            }
                                            return either4;
                                        }
                                        try {
                                            slotToUse = null;
                                            either3 = this.factories;
                                            synchronized (either3) {
                                                for (SessionSlot factory : this.factories) {
                                                    if (!factory.isAvailable() || !factory.test(sessionRequest.getDesiredCapabilities())) continue;
                                                    factory.reserve();
                                                    slotToUse = factory;
                                                    break;
                                                }
                                            }
                                            if (slotToUse != null) break block31;
                                            span.setAttribute(AttributeKey.ERROR.getKey(), true);
                                            span.setStatus(Status.NOT_FOUND);
                                            span.addEvent("No slot matched the requested capabilities. ", attributeMap);
                                            either3 = Either.left((Object)new RetrySessionRequestException("No slot matched the requested capabilities."));
                                            if (span == null) break block32;
                                        }
                                        catch (Throwable throwable) {
                                            if (span != null) {
                                                try {
                                                    span.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        span.close();
                                    }
                                    return either3;
                                }
                                if (this.decrementSessionCount()) break block33;
                                slotToUse.release();
                                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                                span.setStatus(Status.RESOURCE_EXHAUSTED);
                                attributeMap.put("drain.after.session.count", (long)this.configuredSessionCount);
                                span.addEvent("Drain after session count reached", attributeMap);
                                either3 = Either.left((Object)new RetrySessionRequestException("Drain after session count reached."));
                                if (span == null) break block34;
                                span.close();
                            }
                            return either3;
                        }
                        Capabilities desiredCapabilities = sessionRequest.getDesiredCapabilities();
                        if (this.managedDownloadsRequested(desiredCapabilities)) {
                            UUID uuidForSessionDownloads = UUID.randomUUID();
                            downloadsTfs = TemporaryFilesystem.getTmpFsBasedOn((File)TemporaryFilesystem.getDefaultTmpFS().createTempDir("uuid", uuidForSessionDownloads.toString()));
                            Capabilities enhanced = this.setDownloadsDirectory(downloadsTfs, desiredCapabilities);
                            enhanced = desiredCapabilities.merge(enhanced);
                            sessionRequest = new CreateSessionRequest(sessionRequest.getDownstreamDialects(), enhanced, sessionRequest.getMetadata());
                        } else {
                            downloadsTfs = null;
                        }
                        possibleSession = slotToUse.apply(sessionRequest);
                        if (!possibleSession.isRight()) break block35;
                        ActiveSession session = (ActiveSession)possibleSession.right();
                        if (downloadsTfs != null) {
                            this.downloadsTempFileSystem.put((Object)session.getId(), (Object)downloadsTfs);
                        }
                        this.currentSessions.put((Object)session.getId(), (Object)slotToUse);
                        SessionId sessionId = session.getId();
                        Capabilities caps = session.getCapabilities();
                        RemoteTags.SESSION_ID.accept(span, sessionId);
                        RemoteTags.CAPABILITIES.accept(span, caps);
                        String downstream = session.getDownstreamDialect().toString();
                        String upstream = session.getUpstreamDialect().toString();
                        String sessionUri = session.getUri().toString();
                        span.setAttribute(AttributeKey.DOWNSTREAM_DIALECT.getKey(), downstream);
                        span.setAttribute(AttributeKey.UPSTREAM_DIALECT.getKey(), upstream);
                        span.setAttribute(AttributeKey.SESSION_URI.getKey(), sessionUri);
                        Session externalSession = this.createExternalSession(session, this.externalUri, slotToUse.isSupportingCdp(), slotToUse.isSupportingBiDi(), desiredCapabilities);
                        String sessionCreatedMessage = "Session created by the Node";
                        LOG.info(String.format("%s. Id: %s, Caps: %s", sessionCreatedMessage, sessionId, externalSession.getCapabilities()));
                        either2 = Either.right((Object)new CreateSessionResponse(externalSession, (byte[])CapabilityResponseEncoder.getEncoder(session.getDownstreamDialect()).apply(externalSession)));
                        if (span == null) break block36;
                        span.close();
                    }
                    return either2;
                }
                slotToUse.release();
                if (downloadsTfs != null) {
                    downloadsTfs.deleteTemporaryFiles();
                    downloadsTfs.deleteBaseDir();
                }
                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                span.setStatus(Status.ABORTED);
                span.addEvent("Unable to create session with the driver", attributeMap);
                either = Either.left((Object)((Object)((WebDriverException)((Object)possibleSession.left()))));
                if (span == null) break block37;
                span.close();
            }
            return either;
        }
        finally {
            lock.unlock();
            this.checkSessionCount();
        }
    }

    private boolean managedDownloadsRequested(Capabilities capabilities) {
        Object downloadsEnabled = capabilities.getCapability("se:downloadsEnabled");
        return this.managedDownloadsEnabled && downloadsEnabled != null && Boolean.parseBoolean(downloadsEnabled.toString());
    }

    private Capabilities setDownloadsDirectory(TemporaryFilesystem downloadsTfs, Capabilities caps) {
        File tempDir = downloadsTfs.createTempDir("download", "");
        if (Browser.CHROME.is(caps) || Browser.EDGE.is(caps)) {
            Map<String, String> map = Map.of("download.prompt_for_download", false, "download.default_directory", tempDir.getAbsolutePath(), "savefile.default_directory", tempDir.getAbsolutePath());
            String optionsKey = Browser.CHROME.is(caps) ? "goog:chromeOptions" : "ms:edgeOptions";
            return this.appendPrefs(caps, optionsKey, map);
        }
        if (Browser.FIREFOX.is(caps)) {
            Map<String, String> map = Map.of("browser.download.folderList", 2, "browser.download.dir", tempDir.getAbsolutePath());
            return this.appendPrefs(caps, "moz:firefoxOptions", map);
        }
        return caps;
    }

    private Capabilities appendPrefs(Capabilities caps, String optionsKey, Map<String, Serializable> map) {
        if (caps.getCapability(optionsKey) == null) {
            MutableCapabilities mutableCaps = new MutableCapabilities();
            mutableCaps.setCapability(optionsKey, new HashMap());
            caps = caps.merge((Capabilities)mutableCaps);
        }
        Map currentOptions = (Map)caps.getCapability(optionsKey);
        ((Map)currentOptions.computeIfAbsent("prefs", k -> new HashMap())).putAll(map);
        return caps;
    }

    @Override
    public boolean isSessionOwner(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        return this.currentSessions.getIfPresent((Object)id) != null;
    }

    @Override
    public boolean tryAcquireConnection(SessionId id) throws NoSuchSessionException {
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            return false;
        }
        if (this.connectionLimitPerSession == -1) {
            return true;
        }
        AtomicLong counter = slot.getConnectionCounter();
        if ((long)this.connectionLimitPerSession > counter.getAndIncrement()) {
            return true;
        }
        counter.getAndDecrement();
        return false;
    }

    @Override
    public void releaseConnection(SessionId id) {
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            return;
        }
        if (this.connectionLimitPerSession == -1) {
            return;
        }
        AtomicLong counter = slot.getConnectionCounter();
        counter.decrementAndGet();
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        return this.createExternalSession(slot.getSession(), this.externalUri, slot.isSupportingCdp(), slot.isSupportingBiDi(), slot.getSession().getCapabilities());
    }

    @Override
    public TemporaryFilesystem getUploadsFilesystem(SessionId id) throws IOException {
        return (TemporaryFilesystem)this.uploadsTempFileSystem.get((Object)id, key -> TemporaryFilesystem.getTmpFsBasedOn((File)TemporaryFilesystem.getDefaultTmpFS().createTempDir("session", id.toString())));
    }

    @Override
    public TemporaryFilesystem getDownloadsFilesystem(SessionId sessionId) throws IOException {
        return (TemporaryFilesystem)this.downloadsTempFileSystem.getIfPresent((Object)sessionId);
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + String.valueOf(req)));
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        HttpResponse toReturn = slot.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && req.getUri().equals("/session/" + String.valueOf(id))) {
            this.stop(id);
        }
        return toReturn;
    }

    @Override
    public HttpResponse downloadFile(HttpRequest req, SessionId id) {
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot != null && slot.getSession() instanceof DockerSession) {
            return this.executeWebDriverCommand(req);
        }
        if (!this.managedDownloadsEnabled) {
            String msg = "Please enable management of downloads via the command line arg [--enable-managed-downloads] and restart the node";
            throw new WebDriverException(msg);
        }
        TemporaryFilesystem tempFS = (TemporaryFilesystem)this.downloadsTempFileSystem.getIfPresent((Object)id);
        if (tempFS == null) {
            String msg = "Cannot find downloads file system for session id: " + String.valueOf(id) + " \u2014 ensure downloads are enabled in the options class when requesting a session.";
            throw new WebDriverException(msg);
        }
        File downloadsDirectory = Optional.ofNullable(tempFS.getBaseDir().listFiles()).orElse(new File[0])[0];
        try {
            if (req.getMethod().equals((Object)HttpMethod.GET) && req.getUri().endsWith("/se/files")) {
                return this.listDownloadedFiles(downloadsDirectory);
            }
            if (req.getMethod().equals((Object)HttpMethod.GET)) {
                return this.getDownloadedFile(downloadsDirectory, this.extractFileName(req));
            }
            if (req.getMethod().equals((Object)HttpMethod.DELETE)) {
                return this.deleteDownloadedFile(downloadsDirectory);
            }
            return this.getDownloadedFile(req, downloadsDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String extractFileName(HttpRequest req) {
        return this.extractFileName(req.getUri());
    }

    String extractFileName(String uri) {
        String prefix = "/se/files/";
        int index = uri.lastIndexOf(prefix);
        if (index < 0) {
            throw new IllegalArgumentException("Unexpected URL for downloading a file: " + uri);
        }
        return Urls.urlDecode((String)uri.substring(index + prefix.length())).replace(' ', '+');
    }

    private HttpResponse listDownloadedFiles(File downloadsDirectory) {
        File[] files = Optional.ofNullable(downloadsDirectory.listFiles()).orElse(new File[0]);
        List fileNames = Arrays.stream(files).map(File::getName).collect(Collectors.toList());
        List fileInfos = Arrays.stream(files).map(this::getFileInfo).collect(Collectors.toList());
        Map data = Map.of("names", fileNames, "files", fileInfos);
        Map result = Map.of("value", data);
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(result));
    }

    private HasDownloads.DownloadedFile getFileInfo(File file) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new HasDownloads.DownloadedFile(file.getName(), attributes.creationTime().toMillis(), attributes.lastModifiedTime().toMillis(), attributes.size());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to get file attributes: " + file.getAbsolutePath(), e);
        }
    }

    private HttpResponse getDownloadedFile(HttpRequest req, File downloadsDirectory) throws IOException {
        String raw = Contents.string((HttpMessage)req);
        if (raw.isEmpty()) {
            throw new WebDriverException("Please specify file to download in payload as {\"name\": \"fileToDownload\"}");
        }
        Map incoming = (Map)JSON.toType(raw, Json.MAP_TYPE);
        String filename = Optional.ofNullable(incoming.get("name")).map(Object::toString).orElseThrow(() -> new WebDriverException("Please specify file to download in payload as {\"name\": \"fileToDownload\"}"));
        File file = this.findDownloadedFile(downloadsDirectory, filename);
        String content = Zip.zip((File)file);
        Map<String, String> data = Map.of("filename", filename, "file", this.getFileInfo(file), "contents", content);
        Map<String, Map<String, String>> result = Map.of("value", data);
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(result));
    }

    private HttpResponse getDownloadedFile(File downloadsDirectory, String fileName) throws IOException {
        if (fileName.isEmpty()) {
            throw new WebDriverException("Please specify file to download in URL");
        }
        File file = this.findDownloadedFile(downloadsDirectory, fileName);
        BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return (HttpResponse)((HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setHeader("Content-Type", MediaType.OCTET_STREAM.toString())).setHeader("Content-Length", String.valueOf(attributes.size()))).setHeader("Last-Modified", this.lastModifiedHeader(attributes.lastModifiedTime()))).setContent(Contents.file((File)file));
    }

    private String lastModifiedHeader(FileTime fileTime) {
        return HTTP_DATE_FORMAT.format(fileTime.toInstant().atZone(ZoneOffset.UTC));
    }

    private File findDownloadedFile(File downloadsDirectory, String filename) throws WebDriverException {
        List<File> matchingFiles = Arrays.asList(Objects.requireNonNullElseGet(downloadsDirectory.listFiles((dir, name) -> name.equals(filename)), () -> new File[0]));
        if (matchingFiles.isEmpty()) {
            List<File> files = LocalNode.downloadedFiles(downloadsDirectory);
            throw new WebDriverException(String.format("Cannot find file [%s] in directory %s. Found %s files: %s.", filename, downloadsDirectory.getAbsolutePath(), files.size(), files));
        }
        if (matchingFiles.size() != 1) {
            throw new WebDriverException(String.format("Expected there to be only 1 file. Found %s files: %s.", matchingFiles.size(), matchingFiles));
        }
        return matchingFiles.get(0);
    }

    private static List<File> downloadedFiles(File downloadsDirectory) {
        File[] files = Objects.requireNonNullElseGet(downloadsDirectory.listFiles(), () -> new File[0]);
        return Arrays.asList(files);
    }

    private HttpResponse deleteDownloadedFile(File downloadsDirectory) {
        File[] files;
        for (File file : files = Optional.ofNullable(downloadsDirectory.listFiles()).orElse(new File[0])) {
            FileHandler.delete((File)file);
        }
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("value", null);
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(toReturn));
    }

    @Override
    public HttpResponse uploadFile(HttpRequest req, SessionId id) {
        File tempDir;
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot != null && slot.getSession() instanceof DockerSession) {
            return this.executeWebDriverCommand(req);
        }
        Map incoming = (Map)JSON.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
        try {
            TemporaryFilesystem tempFS = this.getUploadsFilesystem(id);
            tempDir = tempFS.createTempDir("upload", "file");
            Zip.unzip((String)((String)incoming.get("file")), (File)tempDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] allFiles = tempDir.listFiles();
        if (allFiles == null) {
            throw new WebDriverException(String.format("Cannot access temporary directory for uploaded files %s", tempDir));
        }
        if (allFiles.length != 1) {
            throw new WebDriverException(String.format("Expected there to be only 1 file. There were: %s", allFiles.length));
        }
        Map<String, String> result = Map.of("value", allFiles[0].getAbsolutePath());
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(result));
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        SessionSlot slot;
        Require.nonNull((String)"Session ID", (Object)id);
        if (this.downloadsTempFileSystem.getIfPresent((Object)id) != null) {
            this.downloadsTempFileSystem.invalidate((Object)id);
        }
        if (this.uploadsTempFileSystem.getIfPresent((Object)id) != null) {
            this.uploadsTempFileSystem.invalidate((Object)id);
        }
        if ((slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id)) == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        this.currentSessions.invalidate((Object)id);
    }

    private void stopAllSessions() {
        LOG.info("Trying to stop all running sessions before shutting down...");
        this.currentSessions.invalidateAll();
    }

    private Session createExternalSession(ActiveSession other, URI externalUri, boolean isSupportingCdp, boolean isSupportingBiDi, Capabilities requestCapabilities) {
        boolean isVncEnabled;
        boolean bidiSupported;
        ImmutableCapabilities toUse = ImmutableCapabilities.copyOf((Capabilities)requestCapabilities.merge(other.getCapabilities()));
        if ((isSupportingCdp || toUse.getCapability("se:cdp") != null) && this.cdpEnabled) {
            String cdpPath = String.format("/session/%s/se/cdp", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:cdp", (Object)this.rewrite(cdpPath));
        } else {
            MutableCapabilities cdpFiltered = new MutableCapabilities();
            toUse.asMap().forEach((key, value) -> {
                if (!key.startsWith("se:cdp")) {
                    cdpFiltered.setCapability(key, value);
                }
            });
            toUse = new PersistentCapabilities((Capabilities)cdpFiltered).setCapability("se:cdpEnabled", (Object)false);
        }
        Object webSocketUrl = toUse.getCapability("webSocketUrl");
        boolean bl = bidiSupported = isSupportingBiDi && webSocketUrl instanceof String;
        if (bidiSupported && this.bidiEnabled) {
            URI uri;
            String biDiUrl = (String)other.getCapabilities().getCapability("webSocketUrl");
            try {
                uri = new URI(biDiUrl);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to create URI from " + biDiUrl);
            }
            String bidiPath = String.format("/session/%s/se/bidi", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:gridWebSocketUrl", (Object)uri).setCapability("webSocketUrl", (Object)this.rewrite(bidiPath));
        } else {
            MutableCapabilities bidiFiltered = new MutableCapabilities();
            toUse.asMap().forEach((key, value) -> {
                if (!key.startsWith("webSocketUrl")) {
                    bidiFiltered.setCapability(key, value);
                }
            });
            toUse = new PersistentCapabilities((Capabilities)bidiFiltered).setCapability("se:bidiEnabled", (Object)false);
        }
        boolean bl2 = isVncEnabled = toUse.getCapability("se:vncLocalAddress") != null;
        if (isVncEnabled) {
            String vncPath = String.format("/session/%s/se/vnc", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:vnc", (Object)this.rewrite(vncPath));
        }
        return new Session(other.getId(), externalUri, other.getStereotype(), (Capabilities)toUse, Instant.now());
    }

    private URI rewrite(String path) {
        try {
            String scheme = "https".equals(this.gridUri.getScheme()) ? "wss" : "ws";
            path = NodeOptions.normalizeSubPath(this.gridUri.getPath()) + (String)path;
            return new URI(scheme, this.gridUri.getUserInfo(), this.gridUri.getHost(), this.gridUri.getPort(), (String)path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NodeStatus getStatus() {
        Set slots = (Set)this.factories.stream().map(slot -> {
            ActiveSession activeSession;
            Instant lastStarted = Instant.EPOCH;
            Session session = null;
            if (!slot.isAvailable() && (activeSession = slot.getSession()) != null) {
                lastStarted = activeSession.getStartTime();
                session = new Session(activeSession.getId(), activeSession.getUri(), slot.getStereotype(), activeSession.getCapabilities(), activeSession.getStartTime());
            }
            return new Slot(new SlotId(this.getId(), slot.getId()), slot.getStereotype(), lastStarted, session);
        }).collect(ImmutableSet.toImmutableSet());
        Availability availability = this.isDraining() ? Availability.DRAINING : Availability.UP;
        Optional<SessionSlot> relaySlot = this.factories.stream().filter(SessionSlot::hasRelayFactory).findFirst();
        if (relaySlot.isPresent() && !relaySlot.get().isRelayServiceUp()) {
            availability = Availability.DOWN;
        }
        return new NodeStatus(this.getId(), this.externalUri, this.maxSessionCount, slots, availability, this.heartbeatPeriod, this.getSessionTimeout(), this.getNodeVersion(), (Map<String, String>)this.getOsInfo());
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public void drain() {
        try (Span span = this.tracer.getCurrentContext().createSpan("node.drain");){
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
            this.bus.fire(new NodeDrainStarted(this.getId()));
            this.draining.set(true);
            this.currentSessions.cleanUp();
            int currentSessionCount = this.getCurrentSessionCount();
            attributeMap.put("current.session.count", (long)currentSessionCount);
            attributeMap.put("node.id", this.getId().toString());
            attributeMap.put("node.drain_after_session_count", (long)this.configuredSessionCount);
            if (currentSessionCount == 0) {
                LOG.info("Firing node drain complete message");
                this.bus.fire(new NodeDrainComplete(this.getId()));
                span.addEvent("Node drain complete", attributeMap);
            } else {
                this.pendingSessions.set(currentSessionCount);
                span.addEvent(String.format("%s session(s) pending before draining Node", attributeMap));
            }
        }
    }

    private void checkSessionCount() {
        if (this.drainAfterSessions) {
            Lock lock = this.drainLock.writeLock();
            if (!lock.tryLock()) {
                return;
            }
            try {
                int remainingSessions = this.sessionCount.get();
                if (remainingSessions <= 0) {
                    LOG.info(String.format("Draining Node, configured sessions value (%s) has been reached.", this.configuredSessionCount));
                    this.drain();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private boolean decrementSessionCount() {
        if (this.drainAfterSessions) {
            int remainingSessions = this.sessionCount.decrementAndGet();
            LOG.log(Debug.getDebugLogLevel(), "{0} remaining sessions before draining Node", remainingSessions);
            return remainingSessions >= 0;
        }
        return true;
    }

    private Map<String, Object> toJson() {
        return Map.of("id", this.getId(), "uri", this.externalUri, "maxSessions", this.maxSessionCount, "draining", this.isDraining(), "capabilities", this.factories.stream().map(SessionSlot::getStereotype).collect(Collectors.toSet()));
    }

    public static class Builder {
        private final Tracer tracer;
        private final EventBus bus;
        private final URI uri;
        private final URI gridUri;
        private final Secret registrationSecret;
        private final ImmutableList.Builder<SessionSlot> factories;
        private int maxSessions = NodeOptions.DEFAULT_MAX_SESSIONS;
        private int drainAfterSessionCount = 0;
        private boolean cdpEnabled = true;
        private boolean bidiEnabled = true;
        private Ticker ticker = Ticker.systemTicker();
        private Duration sessionTimeout = Duration.ofSeconds(300L);
        private HealthCheck healthCheck;
        private Duration heartbeatPeriod = Duration.ofSeconds(60L);
        private boolean managedDownloadsEnabled = false;
        private int connectionLimitPerSession = -1;

        private Builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, Secret registrationSecret) {
            this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
            this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
            this.uri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
            this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
            this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
            this.factories = ImmutableList.builder();
        }

        public Builder add(Capabilities stereotype, SessionFactory factory) {
            Require.nonNull((String)"Capabilities", (Object)stereotype);
            Require.nonNull((String)"Session factory", (Object)factory);
            this.factories.add((Object)new SessionSlot(this.bus, stereotype, factory));
            return this;
        }

        public Builder maximumConcurrentSessions(int maxCount) {
            this.maxSessions = Require.positive((String)"Max session count", (Integer)maxCount);
            return this;
        }

        public Builder drainAfterSessionCount(int sessionCount) {
            this.drainAfterSessionCount = sessionCount;
            return this;
        }

        public Builder enableCdp(boolean cdpEnabled) {
            this.cdpEnabled = cdpEnabled;
            return this;
        }

        public Builder enableBiDi(boolean bidiEnabled) {
            this.bidiEnabled = bidiEnabled;
            return this;
        }

        public Builder sessionTimeout(Duration timeout) {
            this.sessionTimeout = timeout;
            return this;
        }

        public Builder heartbeatPeriod(Duration heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public Builder enableManagedDownloads(boolean enable) {
            this.managedDownloadsEnabled = enable;
            return this;
        }

        public Builder connectionLimitPerSession(int connectionLimitPerSession) {
            this.connectionLimitPerSession = connectionLimitPerSession;
            return this;
        }

        public LocalNode build() {
            return new LocalNode(this.tracer, this.bus, this.uri, this.gridUri, this.healthCheck, this.maxSessions, this.drainAfterSessionCount, this.cdpEnabled, this.bidiEnabled, this.ticker, this.sessionTimeout, this.heartbeatPeriod, (List<SessionSlot>)this.factories.build(), this.registrationSecret, this.managedDownloadsEnabled, this.connectionLimitPerSession);
        }

        public Advanced advanced() {
            return new Advanced();
        }

        public class Advanced {
            public Advanced clock(final Clock clock) {
                Builder.this.ticker = new Ticker(){

                    public long read() {
                        return clock.instant().toEpochMilli() * Duration.ofMillis(1L).toNanos();
                    }
                };
                return this;
            }

            public Advanced healthCheck(HealthCheck healthCheck) {
                Builder.this.healthCheck = (HealthCheck)Require.nonNull((String)"Health check", (Object)healthCheck);
                return this;
            }

            public Node build() {
                return Builder.this.build();
            }
        }
    }
}

