/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.util.Map;
import org.openqa.selenium.grid.data.SessionClosedReason;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.SessionId;

public class SessionClosedData {
    private final SessionId sessionId;
    private final SessionClosedReason reason;

    public SessionClosedData(SessionId sessionId, SessionClosedReason reason) {
        this.sessionId = (SessionId)Require.nonNull((String)"Session ID", (Object)sessionId);
        this.reason = (SessionClosedReason)((Object)Require.nonNull((String)"Reason", (Object)((Object)reason)));
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public SessionClosedReason getReason() {
        return this.reason;
    }

    public String toString() {
        return String.format("SessionClosedData{sessionId=%s, reason=%s}", new Object[]{this.sessionId, this.reason});
    }

    private Object toJson() {
        return Map.of("sessionId", this.sessionId, "reason", this.reason);
    }

    private static SessionClosedData fromJson(Object raw) {
        if (raw instanceof Map) {
            Map map = (Map)raw;
            Object sessionIdObj = map.get("sessionId");
            Object reasonObj = map.get("reason");
            if (sessionIdObj instanceof String) {
                SessionId sessionId = new SessionId((String)sessionIdObj);
                SessionClosedReason reason = SessionClosedReason.valueOf((String)reasonObj);
                return new SessionClosedData(sessionId, reason);
            }
        }
        throw new JsonException("Unable to coerce session closed data from " + String.valueOf(raw));
    }
}

