/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.log.FlushingHandler;
import org.openqa.selenium.grid.log.JsonFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.empty.NullTracer;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;

public class LoggingOptions {
    static final String LOGGING_SECTION = "logging";
    static final boolean DEFAULT_CONFIGURE_LOGGING = true;
    static final String DEFAULT_LOG_LEVEL = Level.INFO.getName();
    static final boolean DEFAULT_PLAIN_LOGS = true;
    static final boolean DEFAULT_STRUCTURED_LOGS = false;
    static final boolean DEFAULT_TRACING_ENABLED = true;
    public static final boolean DEFAULT_HTTP_LOGS = false;
    private static final Logger LOG = Logger.getLogger(LoggingOptions.class.getName());
    private final Config config;
    private Level level = Level.INFO;
    public static final String DEFAULT_LOG_TIMESTAMP_FORMAT = "HH:mm:ss.SSS";

    public LoggingOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public boolean isUsingStructuredLogging() {
        return this.config.getBool(LOGGING_SECTION, "structured-logs").orElse(false);
    }

    public boolean shouldLogHttpLogs() {
        return this.config.getBool(LOGGING_SECTION, "http-logs").orElse(false);
    }

    public boolean isUsingPlainLogs() {
        return this.config.getBool(LOGGING_SECTION, "plain-logs").orElse(true);
    }

    public String getLogEncoding() {
        return this.config.get(LOGGING_SECTION, "log-encoding").orElse(null);
    }

    public void setLoggingLevel() {
        String configLevel = this.config.get(LOGGING_SECTION, "log-level").orElse(DEFAULT_LOG_LEVEL);
        try {
            this.level = Level.parse(configLevel.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Unable to determine log level from " + configLevel, new Object[0]);
        }
    }

    public Tracer getTracer() {
        boolean tracingEnabled = this.config.getBool(LOGGING_SECTION, "tracing").orElse(true);
        if (!tracingEnabled) {
            LOG.info("Using null tracer");
            return new NullTracer();
        }
        OpenTelemetryTracer.setHttpLogs((boolean)this.shouldLogHttpLogs());
        return OpenTelemetryTracer.getInstance();
    }

    public void configureLogging() {
        FlushingHandler handler;
        Logger logger;
        if (!this.config.getBool(LOGGING_SECTION, "enable").orElse(true).booleanValue()) {
            return;
        }
        if (LogManager.getLogManager().getProperty("handlers") != null) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        while (names.hasMoreElements()) {
            logger = logManager.getLogger(names.nextElement());
            if (logger == null) continue;
            Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler);
        }
        logger = logManager.getLogger("");
        this.setLoggingLevel();
        logger.setLevel(this.level);
        OutputStream out = this.getOutputStream();
        String encoding = this.getLogEncoding();
        if (this.isUsingPlainLogs()) {
            handler = new FlushingHandler(out);
            handler.setFormatter(new TerseFormatter(this.getLogTimestampFormat()));
            handler.setLevel(this.level);
            this.configureLogEncoding(logger, encoding, handler);
        }
        if (this.isUsingStructuredLogging()) {
            handler = new FlushingHandler(out);
            handler.setFormatter(new JsonFormatter());
            handler.setLevel(this.level);
            this.configureLogEncoding(logger, encoding, handler);
        }
    }

    private void configureLogEncoding(Logger logger, String encoding, Handler handler) {
        String message;
        try {
            if (encoding != null) {
                handler.setEncoding(encoding);
                message = String.format("Using encoding %s", encoding);
            } else {
                message = "Using the system default encoding";
            }
        }
        catch (UnsupportedEncodingException e) {
            message = String.format("Using the system default encoding. Unsupported encoding %s", encoding);
        }
        logger.addHandler(handler);
        logger.log(Level.INFO, message);
    }

    private OutputStream getOutputStream() {
        return this.config.get(LOGGING_SECTION, "log-file").map(fileName -> {
            try {
                return new FileOutputStream((String)fileName);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }).orElse(System.out);
    }

    public String getLogTimestampFormat() {
        return this.config.get(LOGGING_SECTION, "log-timestamp-format").orElse(DEFAULT_LOG_TIMESTAMP_FORMAT);
    }
}

