/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openqa.selenium.grid.web.Resource;
import org.openqa.selenium.internal.Require;

public class JarFileResource
implements Resource {
    private final JarFile jarFile;
    private final String entryName;
    private final String stripPrefix;

    public JarFileResource(JarFile jarFile, String entryName, String stripPrefix) {
        this.jarFile = (JarFile)Require.nonNull((String)"Jar file", (Object)jarFile);
        this.entryName = (String)Require.nonNull((String)"Entry name", (Object)entryName);
        Require.nonNull((String)"Prefix", (Object)stripPrefix);
        this.stripPrefix = stripPrefix.endsWith("/") ? stripPrefix : stripPrefix + "/";
        Require.precondition((boolean)entryName.startsWith(stripPrefix), (String)"Entry is not under stripped prefix", (Object[])new Object[0]);
    }

    @Override
    public String name() {
        return this.entryName.substring(this.stripPrefix.length());
    }

    @Override
    public Optional<Resource> get(String path) {
        Require.nonNull((String)"Path", (Object)path);
        if (!this.isDirectory()) {
            return Optional.empty();
        }
        String name = this.stripPrefix + this.stripLeadingSlash(path);
        ZipEntry entry = this.jarFile.getEntry(name);
        return Optional.ofNullable(entry).map(e -> new JarFileResource(this.jarFile, entry.getName(), name));
    }

    private String stripLeadingSlash(String from) {
        if (!from.startsWith("/")) {
            return from;
        }
        if ("/".equals(from)) {
            return "";
        }
        if (from.length() < 2) {
            throw new IllegalArgumentException("From string must have something following the slash: " + from);
        }
        return from.substring(1);
    }

    @Override
    public boolean isDirectory() {
        return this.jarFile.getEntry(this.entryName).isDirectory();
    }

    @Override
    public Set<Resource> list() {
        if (!this.isDirectory()) {
            return ImmutableSet.of();
        }
        Object prefix = this.entryName.endsWith("/") ? this.entryName : this.entryName + "/";
        int count = ((String)prefix).split("/").length + 1;
        return (Set)this.jarFile.stream().filter(arg_0 -> JarFileResource.lambda$list$1((String)prefix, arg_0)).filter(e -> !e.getName().equals(this.entryName)).filter(arg_0 -> JarFileResource.lambda$list$3((String)prefix, arg_0)).filter(e -> e.getName().split("/").length == count).map(arg_0 -> this.lambda$list$5((String)prefix, arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<byte[]> read() {
        ZipEntry entry = this.jarFile.getEntry(this.entryName);
        if (entry.isDirectory()) {
            return Optional.empty();
        }
        try (InputStream is = this.jarFile.getInputStream(entry);){
            Optional<byte[]> optional;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                ByteStreams.copy((InputStream)is, (OutputStream)bos);
                optional = Optional.of(bos.toByteArray());
            }
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private /* synthetic */ JarFileResource lambda$list$5(String prefix, JarEntry e) {
        return new JarFileResource(this.jarFile, e.getName(), prefix);
    }

    private static /* synthetic */ boolean lambda$list$3(String prefix, JarEntry e) {
        return !e.getName().equals(prefix);
    }

    private static /* synthetic */ boolean lambda$list$1(String prefix, JarEntry e) {
        return e.getName().startsWith(prefix);
    }
}

