/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;

@ManagedService(objectName="org.seleniumhq.grid:type=Config,name=NewSessionQueueConfig", description="New session queue config")
public class NewSessionQueueOptions {
    static final String SESSION_QUEUE_SECTION = "sessionqueue";
    static final int DEFAULT_REQUEST_TIMEOUT = 300;
    static final int DEFAULT_REQUEST_TIMEOUT_PERIOD = 10;
    static final int DEFAULT_RETRY_INTERVAL = 15;
    static final int DEFAULT_BATCH_SIZE = Runtime.getRuntime().availableProcessors() * 3;
    private final Config config;

    public NewSessionQueueOptions(Config config) {
        this.config = config;
        new JMXHelper().register(this);
    }

    public URI getSessionQueueUri() {
        Optional<URI> host = this.config.get(SESSION_QUEUE_SECTION, "host").map(str -> {
            try {
                URI sessionQueueUri = new URI((String)str);
                if (sessionQueueUri.getHost() == null || sessionQueueUri.getPort() == -1) {
                    throw new ConfigException("Undefined host or port in SessionQueue server URI: " + str, new Object[0]);
                }
                return sessionQueueUri;
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Session queue server URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt(SESSION_QUEUE_SECTION, "port");
        Optional<String> hostname = this.config.get(SESSION_QUEUE_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the session queue server", new Object[0]);
        }
        try {
            return new URI("http", null, hostname.get(), port.get(), "", null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Session queue server uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }

    public Duration getSessionRequestTimeout() {
        int timeout = Math.max(this.config.getInt(SESSION_QUEUE_SECTION, "session-request-timeout").orElse(300), 1);
        return Duration.ofSeconds(timeout);
    }

    public Duration getSessionRequestTimeoutPeriod() {
        int timeout = Math.max(this.config.getInt(SESSION_QUEUE_SECTION, "session-request-timeout-period").orElse(10), 1);
        return Duration.ofSeconds(timeout);
    }

    public Duration getSessionRequestRetryInterval() {
        int interval = Math.max(this.config.getInt(SESSION_QUEUE_SECTION, "session-retry-interval").orElse(15), 15);
        return Duration.ofMillis(interval);
    }

    public int getBatchSize() {
        int batchSize = Math.max(this.config.getInt(SESSION_QUEUE_SECTION, "sessionqueue-batch-size").orElse(DEFAULT_BATCH_SIZE), 1);
        return batchSize;
    }

    @ManagedAttribute(name="RequestTimeoutSeconds")
    public long getRequestTimeoutSeconds() {
        return this.getSessionRequestTimeout().getSeconds();
    }

    @ManagedAttribute(name="RetryIntervalMilliseconds")
    public long getRetryIntervalMilliseconds() {
        return this.getSessionRequestRetryInterval().toMillis();
    }

    public NewSessionQueue getSessionQueue(String implementation) {
        return this.config.getClass(SESSION_QUEUE_SECTION, "implementation", NewSessionQueue.class, implementation);
    }
}

