/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.docker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.docker.DockerAssetsPath;
import org.openqa.selenium.grid.node.docker.DockerSessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.HostIdentifier;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.tracing.Tracer;

public class DockerOptions {
    static final String DOCKER_SECTION = "docker";
    static final String DEFAULT_ASSETS_PATH = "/opt/selenium/assets";
    static final String DEFAULT_DOCKER_URL = "unix:/var/run/docker.sock";
    static final String DEFAULT_VIDEO_IMAGE = "selenium/video:latest";
    static final int DEFAULT_MAX_SESSIONS = Runtime.getRuntime().availableProcessors();
    private static final String DEFAULT_DOCKER_NETWORK = "bridge";
    private static final Logger LOG = Logger.getLogger(DockerOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public DockerOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    private URI getDockerUri() {
        try {
            Optional possibleUri = this.config.get(DOCKER_SECTION, "url");
            if (possibleUri.isPresent()) {
                return new URI((String)possibleUri.get());
            }
            Optional possibleHost = this.config.get(DOCKER_SECTION, "host");
            Optional possiblePort = this.config.getInt(DOCKER_SECTION, "port");
            if (possibleHost.isPresent() && possiblePort.isPresent()) {
                String host = (String)possibleHost.get();
                int port = (Integer)possiblePort.get();
                host = !host.startsWith("tcp:") && !host.startsWith("http:") && !host.startsWith("https") ? String.format("http://%s:%s", host, port) : String.format("%s:%s", host, port);
                URI uri = new URI(host);
                return new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                return new URI("http://localhost:2376");
            }
            return new URI(DEFAULT_DOCKER_URL);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Unable to determine docker url", new Object[]{e});
        }
    }

    private boolean isEnabled(Docker docker) {
        if (!this.config.getAll(DOCKER_SECTION, "configs").isPresent()) {
            return false;
        }
        return docker.isSupported();
    }

    public Map<Capabilities, Collection<SessionFactory>> getDockerSessionFactories(Tracer tracer, HttpClient.Factory clientFactory) {
        HttpClient client = clientFactory.createClient(ClientConfig.defaultConfig().baseUri(this.getDockerUri()));
        Docker docker = new Docker((HttpHandler)client);
        if (!this.isEnabled(docker)) {
            throw new DockerException("Unable to reach the Docker daemon at " + this.getDockerUri());
        }
        List allConfigs = (List)this.config.getAll(DOCKER_SECTION, "configs").orElseThrow(() -> new DockerException("Unable to find docker configs"));
        HashMultimap kinds = HashMultimap.create();
        for (int i = 0; i < allConfigs.size(); ++i) {
            String imageName = (String)allConfigs.get(i);
            if (++i == allConfigs.size()) {
                throw new DockerException("Unable to find JSON config");
            }
            Capabilities stereotype = (Capabilities)JSON.toType((String)allConfigs.get(i), Capabilities.class);
            kinds.put((Object)imageName, (Object)stereotype);
        }
        String hostname = HostIdentifier.getHostName();
        Optional<ContainerInfo> info = docker.inspect(new ContainerId(hostname));
        DockerAssetsPath assetsPath = this.getAssetsPath(info);
        String networkName = this.getDockerNetworkName(info);
        this.loadImages(docker, kinds.keySet().toArray(new String[0]));
        Image videoImage = this.getVideoImage(docker);
        this.loadImages(docker, videoImage.getName());
        int maxContainerCount = Math.min(this.config.getInt("node", "max-sessions").orElse(DEFAULT_MAX_SESSIONS), DEFAULT_MAX_SESSIONS);
        ImmutableMultimap.Builder factories = ImmutableMultimap.builder();
        kinds.forEach((name, caps) -> {
            Image image = docker.getImage((String)name);
            for (int i = 0; i < maxContainerCount; ++i) {
                factories.put(caps, (Object)new DockerSessionFactory(tracer, clientFactory, docker, this.getDockerUri(), image, (Capabilities)caps, videoImage, assetsPath, networkName, info.isPresent()));
            }
            LOG.info(String.format("Mapping %s to docker image %s %d times", caps, name, maxContainerCount));
        });
        return factories.build().asMap();
    }

    private Image getVideoImage(Docker docker) {
        String videoImage = this.config.get(DOCKER_SECTION, "video-image").orElse(DEFAULT_VIDEO_IMAGE);
        return docker.getImage(videoImage);
    }

    private String getDockerNetworkName(Optional<ContainerInfo> info) {
        if (info.isPresent()) {
            return info.get().getNetworkName();
        }
        return DEFAULT_DOCKER_NETWORK;
    }

    private DockerAssetsPath getAssetsPath(Optional<ContainerInfo> info) {
        Optional<Map> mountedVolume;
        if (info.isPresent() && (mountedVolume = info.get().getMountedVolumes().stream().filter(mounted -> DEFAULT_ASSETS_PATH.equalsIgnoreCase(String.valueOf(mounted.get("Destination")))).findFirst()).isPresent()) {
            String hostPath = String.valueOf(mountedVolume.get().get("Source"));
            return new DockerAssetsPath(hostPath, DEFAULT_ASSETS_PATH);
        }
        Optional assetsPath = this.config.get(DOCKER_SECTION, "assets-path");
        return assetsPath.map(path -> new DockerAssetsPath((String)path, (String)path)).orElse(null);
    }

    private void loadImages(Docker docker, String ... imageNames) {
        CompletableFuture<Void> cd = CompletableFuture.allOf((CompletableFuture[])Arrays.stream(imageNames).map(name -> CompletableFuture.supplyAsync(() -> docker.getImage((String)name))).toArray(CompletableFuture[]::new));
        try {
            cd.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

